/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util.compat.crafttweaker;

import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.util.UpgradeRecipe;
import com.shultrea.rin.util.compat.crafttweaker.CraftTweakerUpgradeRecipe;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="somanyenchantments.UpgradeEnchantments")
public class CraftTweakerCompat {
    private static final List<IAction> recipesToAdd = new ArrayList<IAction>();
    private static final List<IAction> recipesToRemove = new ArrayList<IAction>();
    private static final List<IAction> recipesToChange = new ArrayList<IAction>();

    @ZenMethod
    public static void removeAllRecipes() {
        recipesToRemove.add(new ActionRemoveAllUpgradeRecipes());
    }

    @ZenMethod
    public static void removeRecipe(IEnchantmentDefinition in, IEnchantmentDefinition out) {
        recipesToRemove.add(new ActionRemoveUpgradeRecipe(CraftTweakerCompat.reloadEnchantment(in.getInternal()), CraftTweakerCompat.reloadEnchantment(out.getInternal())));
    }

    @ZenMethod
    public static void setUpgradeTokenForRecipe(IEnchantmentDefinition in, IEnchantmentDefinition out, IItemStack upgradeToken) {
        recipesToChange.add(new ActionChangeUpgradeToken(in, out, upgradeToken));
    }

    @ZenMethod
    public static void setCurseForRecipe(IEnchantmentDefinition in, IEnchantmentDefinition out, IEnchantmentDefinition curse, float cursingChance) {
        recipesToChange.add(new ActionChangeCurse(in, out, curse, cursingChance));
    }

    @ZenMethod
    public static void setCurseForRecipe(IEnchantmentDefinition in, IEnchantmentDefinition out, IEnchantmentDefinition curse) {
        recipesToChange.add(new ActionChangeCurse(in, out, curse));
    }

    @ZenMethod
    public static CraftTweakerUpgradeRecipe addRecipe(IEnchantmentDefinition in, IEnchantmentDefinition out) {
        CraftTweakerUpgradeRecipe newRecipe = new CraftTweakerUpgradeRecipe(new UpgradeRecipe(CraftTweakerCompat.reloadEnchantment(in.getInternal()), CraftTweakerCompat.reloadEnchantment(out.getInternal())));
        recipesToAdd.add(new ActionAddUpgradeRecipe(newRecipe));
        return newRecipe;
    }

    public static void applyActions() {
        CraftTweaker.INSTANCE.applyActions(recipesToRemove, "", "");
        CraftTweaker.INSTANCE.applyActions(recipesToChange, "", "");
        CraftTweaker.INSTANCE.applyActions(recipesToAdd, "", "");
        UpgradeRecipe.cleanupUpgradeTokens();
    }

    public static Enchantment reloadEnchantment(Object original) {
        if (!(original instanceof Enchantment)) {
            return null;
        }
        Enchantment enchantment = (Enchantment)original;
        if (enchantment.getRegistryName() == null) {
            return enchantment;
        }
        return Enchantment.func_180305_b((String)enchantment.getRegistryName().toString());
    }

    public static class ActionChangeCurse
    implements IAction {
        private final float cursingChance;
        private final Enchantment enchIn;
        private final Enchantment enchOut;
        private final Enchantment enchCurse;

        public ActionChangeCurse(IEnchantmentDefinition enchIn, IEnchantmentDefinition enchOut, IEnchantmentDefinition curse, float cursingChance) {
            this.enchIn = CraftTweakerCompat.reloadEnchantment(enchIn.getInternal());
            this.enchOut = CraftTweakerCompat.reloadEnchantment(enchOut.getInternal());
            this.enchCurse = CraftTweakerCompat.reloadEnchantment(curse.getInternal());
            this.cursingChance = cursingChance;
        }

        public ActionChangeCurse(IEnchantmentDefinition enchIn, IEnchantmentDefinition enchOut, IEnchantmentDefinition curse) {
            this(enchIn, enchOut, curse, enchIn.getInternal() == enchOut.getInternal() ? ModConfig.upgrade.upgradeFailChanceLevel : ModConfig.upgrade.upgradeFailChanceTier);
        }

        public void apply() {
            UpgradeRecipe.UPGRADE_RECIPES.stream().filter(r -> r.getInput().equals(this.enchIn) && r.getOutputEnchant().equals(this.enchOut)).forEach(r -> r.setCurse(this.enchCurse, this.cursingChance));
        }

        public String describe() {
            return "";
        }
    }

    public static class ActionChangeUpgradeToken
    implements IAction {
        private final ItemStack upgradeToken;
        private final Enchantment enchIn;
        private final Enchantment enchOut;

        public ActionChangeUpgradeToken(IEnchantmentDefinition enchIn, IEnchantmentDefinition enchOut, IItemStack upgradeToken) {
            this.upgradeToken = (ItemStack)upgradeToken.getInternal();
            this.enchIn = CraftTweakerCompat.reloadEnchantment(enchIn.getInternal());
            this.enchOut = CraftTweakerCompat.reloadEnchantment(enchOut.getInternal());
        }

        public void apply() {
            UpgradeRecipe.UPGRADE_RECIPES.stream().filter(r -> r.getInput().equals(this.enchIn) && r.getOutputEnchant().equals(this.enchOut)).forEach(r -> r.setTokenCost(this.upgradeToken));
        }

        public String describe() {
            return "";
        }
    }

    public static class ActionAddUpgradeRecipe
    implements IAction {
        CraftTweakerUpgradeRecipe recipe;

        public ActionAddUpgradeRecipe(CraftTweakerUpgradeRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            UpgradeRecipe.UPGRADE_RECIPES.add(this.recipe.getInternal());
        }

        public String describe() {
            return "";
        }
    }

    public static class ActionRemoveAllUpgradeRecipes
    implements IAction {
        public void apply() {
            UpgradeRecipe.UPGRADE_RECIPES.clear();
        }

        public String describe() {
            return "";
        }
    }

    public static class ActionRemoveUpgradeRecipe
    implements IAction {
        private final Enchantment in;
        private final Enchantment out;

        public ActionRemoveUpgradeRecipe(Enchantment in, Enchantment out) {
            this.in = in;
            this.out = out;
        }

        public void apply() {
            UpgradeRecipe.UPGRADE_RECIPES.removeIf(r -> r.getInput().equals(this.in) && r.getOutputEnchant().equals(this.out));
        }

        public String describe() {
            return "";
        }
    }
}

