/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util.compat;

import bettercombat.mod.compat.EnchantCompatHandler;
import bettercombat.mod.event.RLCombatCriticalHitEvent;
import bettercombat.mod.event.RLCombatSweepEvent;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class RLCombatCompat {
    public static ItemStack getArthropodStack(EntityLivingBase entity) {
        if (EnchantCompatHandler.arthropodFromOffhand) {
            return entity.func_184592_cb();
        }
        return entity.func_184614_ca();
    }

    public static ItemStack getKnockbackStack(EntityLivingBase entity) {
        if (EnchantCompatHandler.knockbackFromOffhand) {
            return entity.func_184592_cb();
        }
        return entity.func_184614_ca();
    }

    public static ItemStack getFireAspectStack(EntityLivingBase entity) {
        if (EnchantCompatHandler.fireAspectFromOffhand) {
            return entity.func_184592_cb();
        }
        return entity.func_184614_ca();
    }

    public static float getOnEntityDamagedAltStrength() {
        return EnchantCompatHandler.arthropodCooledStrength;
    }

    public static boolean isOnEntityDamagedAltStrong() {
        return RLCombatCompat.getOnEntityDamagedAltStrength() > 0.9f;
    }

    public static float getAttackEntityFromStrength() {
        return EnchantCompatHandler.attackEntityFromCooledStrength;
    }

    public static boolean isAttackEntityFromStrong() {
        return RLCombatCompat.getAttackEntityFromStrength() > 0.9f;
    }

    public static float getCriticalHitEventStrength(CriticalHitEvent event) {
        if (!(event instanceof RLCombatCriticalHitEvent)) {
            return 1.0f;
        }
        RLCombatCriticalHitEvent rlEvent = (RLCombatCriticalHitEvent)event;
        return rlEvent.getCooledStrength();
    }

    public static boolean isCriticalHitEventStrong(CriticalHitEvent event) {
        return RLCombatCompat.getCriticalHitEventStrength(event) > 0.9f;
    }

    public static ItemStack getCriticalHitEventStack(CriticalHitEvent event, EntityLivingBase entity) {
        if (!(event instanceof RLCombatCriticalHitEvent)) {
            return entity.func_184614_ca();
        }
        RLCombatCriticalHitEvent rlEvent = (RLCombatCriticalHitEvent)event;
        return rlEvent.getOffhand() ? entity.func_184592_cb() : entity.func_184614_ca();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRLCombatSweepEvent(RLCombatSweepEvent event) {
        if (!EnchantmentRegistry.arcSlash.isEnabled()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.arcSlash, (ItemStack)event.getItemStack());
        if (level > 0 && event.getEntityPlayer() != null && event.getTargetEntity() != null) {
            event.setDoSweep(true);
            event.setSweepModifier(Math.max(event.getSweepModifier(), (float)level * 0.2f));
        }
    }
}

