/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class UpgradeRecipe {
    public static final int DENY = -99;
    private final Enchantment enchIn;
    private final Enchantment enchOut;
    private ItemStack tokenCost;
    private UpgradeRecipe cursingRecipe = null;
    private float curseChance = 0.0f;
    private boolean isCursingRecipe = false;
    private Function<Integer, Integer> levelAlgo;
    public static final List<UpgradeRecipe> UPGRADE_RECIPES = new ArrayList<UpgradeRecipe>();
    private static final List<ItemStack> UPGRADE_TOKENS = new ArrayList<ItemStack>();

    public UpgradeRecipe(Enchantment enchIn, Enchantment enchOut) {
        this.enchIn = enchIn;
        this.enchOut = enchOut;
        boolean isLevelUpgrade = enchIn == enchOut;
        this.tokenCost = ConfigProvider.getDefaultUpgradeTokenItems(isLevelUpgrade);
        this.levelAlgo = isLevelUpgrade ? lvlIn -> lvlIn < enchIn.func_77325_b() ? lvlIn + 1 : -99 : (ModConfig.upgrade.upgradedTierLevelMode == 0 ? lvlIn -> {
            int reduction = ModConfig.upgrade.upgradedTierLevelReduction;
            reduction = Math.min(reduction, this.enchIn.func_77325_b() - this.enchOut.func_77319_d());
            int newLvl = lvlIn - reduction;
            return newLvl >= enchOut.func_77319_d() ? Math.min(newLvl, enchOut.func_77325_b()) : -99;
        } : lvlIn -> lvlIn >= enchIn.func_77325_b() ? enchOut.func_77319_d() : -99);
    }

    public UpgradeRecipe setCurse(Enchantment curse, float curseChance) {
        if (curse != null) {
            this.cursingRecipe = new UpgradeRecipe(this.enchIn, curse).setIsCursingRecipe().setLevelAlgo(lvlIn -> 1).setTokenCost(this.tokenCost);
            this.curseChance = curseChance;
        }
        return this;
    }

    public UpgradeRecipe setIsCursingRecipe() {
        this.isCursingRecipe = true;
        return this;
    }

    public UpgradeRecipe setLevelAlgo(Function<Integer, Integer> algo) {
        this.levelAlgo = algo;
        return this;
    }

    public UpgradeRecipe setTokenCost(ItemStack token) {
        this.tokenCost = token;
        if (this.cursingRecipe != null) {
            this.cursingRecipe.setTokenCost(token);
        }
        UpgradeRecipe.addUpgradeToken(token);
        return this;
    }

    public Enchantment getInput() {
        return this.enchIn;
    }

    public UpgradeRecipe getUsedRecipe(Random rand, boolean isPreview) {
        if (this.cursingRecipe != null && !isPreview && rand.nextFloat() < this.curseChance) {
            return this.cursingRecipe;
        }
        return this;
    }

    public Enchantment getOutputEnchant() {
        return this.enchOut;
    }

    public ItemStack getTokenCost() {
        return this.tokenCost;
    }

    public boolean getIsCursingRecipe() {
        return this.isCursingRecipe;
    }

    public UpgradeRecipe getCursingRecipe() {
        return this.cursingRecipe;
    }

    public float getCurseChance() {
        return this.curseChance;
    }

    public int getOutputLvl(int enchLvlIn) {
        return this.levelAlgo.apply(enchLvlIn);
    }

    public Map<Enchantment, Integer> getOutputStackEnchants(ItemStack stackIn) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stackIn);
        LinkedHashMap<Enchantment, Integer> newEnchantments = new LinkedHashMap<Enchantment, Integer>();
        boolean alreadyUpgraded = false;
        for (Map.Entry entry : enchants.entrySet()) {
            if (!alreadyUpgraded && this.enchIn.equals(entry.getKey())) {
                if (!this.isCursingRecipe) {
                    newEnchantments.put(this.enchOut, this.levelAlgo.apply((Integer)entry.getValue()));
                } else if (!ModConfig.upgrade.upgradeFailRemovesOriginal) {
                    newEnchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
                }
                alreadyUpgraded = true;
                continue;
            }
            newEnchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        if (this.isCursingRecipe) {
            int minLvl = this.enchOut.func_77319_d();
            if (newEnchantments.containsKey(this.enchOut)) {
                int currentLvl = (Integer)newEnchantments.get(this.enchOut);
                int newLvl = MathHelper.func_76125_a((int)(currentLvl + 1), (int)minLvl, (int)this.enchOut.func_77325_b());
                newEnchantments.put(this.enchOut, newLvl);
            } else {
                newEnchantments.put(this.enchOut, minLvl);
            }
        }
        return newEnchantments;
    }

    public int canUpgrade(ItemStack itemStack) {
        Map currentEnchants = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        block0: for (Map.Entry enchants : currentEnchants.entrySet()) {
            int upgradedLevel = this.canUpgrade((Enchantment)enchants.getKey(), (Integer)enchants.getValue());
            if (upgradedLevel == -99 || (itemStack.func_77973_b() == Items.field_151134_bR ? !this.enchOut.isAllowedOnBooks() : !this.enchOut.func_92089_a(itemStack))) continue;
            if (ModConfig.upgrade.onlyAllowCompatible) {
                for (Enchantment ench : currentEnchants.keySet()) {
                    if (ench == enchants.getKey() || this.enchOut.func_191560_c(ench)) continue;
                    continue block0;
                }
            }
            return upgradedLevel;
        }
        return -99;
    }

    public int canUpgrade(Enchantment enchantment, int level) {
        return enchantment == this.enchIn ? this.levelAlgo.apply(level) : -99;
    }

    public boolean upgradeTokenIsValid(ItemStack tokenStack) {
        if (tokenStack.func_77973_b() != this.tokenCost.func_77973_b()) {
            return false;
        }
        if (this.tokenCost.func_77960_j() != Short.MAX_VALUE && tokenStack.func_77960_j() != this.tokenCost.func_77960_j()) {
            return false;
        }
        return tokenStack.func_190916_E() >= this.tokenCost.func_190916_E();
    }

    public String toString() {
        try {
            String s = "UpgradeRecipe from " + this.getInput().getRegistryName().toString();
            s = s + " to " + this.getOutputEnchant().getRegistryName().toString();
            s = s + " using " + this.getTokenCost().func_77973_b().getRegistryName().toString() + ":" + (this.getTokenCost().func_77960_j() == 3767 ? "*" : Integer.valueOf(this.getTokenCost().func_77960_j())) + " count " + this.getTokenCost().func_190916_E();
            if (this.cursingRecipe != null) {
                s = s + " has curse " + this.cursingRecipe.getOutputEnchant().getRegistryName().toString() + " chance " + this.curseChance;
            }
            return s;
        }
        catch (Exception e) {
            return "Caught exception during toString representation of UpgradeRecipe";
        }
    }

    public static void resetUpgradeRecipes() {
        UPGRADE_RECIPES.clear();
        UPGRADE_TOKENS.clear();
    }

    public static void initUpgradeRecipes() {
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS.getValuesCollection().stream().sorted(Comparator.comparingInt(Enchantment::func_185258_b)).collect(Collectors.toList())) {
            Enchantment upgradedEnchant;
            Enchantment curse = ConfigProvider.getFailureEnchantFor(ench);
            if (ModConfig.upgrade.allowLevelUpgrades && !ench.func_190936_d() && ench.func_77325_b() > ench.func_77319_d()) {
                UpgradeRecipe recipe = new UpgradeRecipe(ench, ench).setCurse(curse, ModConfig.upgrade.upgradeFailChanceLevel);
                UPGRADE_RECIPES.add(recipe);
                UpgradeRecipe.addUpgradeToken(recipe.getTokenCost());
            }
            if (!ModConfig.upgrade.allowTierUpgrades || (upgradedEnchant = ConfigProvider.getUpgradedEnchantFor(ench)) == null) continue;
            UpgradeRecipe recipe = new UpgradeRecipe(ench, upgradedEnchant).setCurse(curse, ModConfig.upgrade.upgradeFailChanceTier);
            UPGRADE_RECIPES.add(recipe);
            UpgradeRecipe.addUpgradeToken(recipe.getTokenCost());
        }
    }

    public static void addUpgradeToken(ItemStack token) {
        for (ItemStack stack : UPGRADE_TOKENS) {
            if (!stack.func_77973_b().equals(token.func_77973_b()) || stack.func_77960_j() != token.func_77960_j() || stack.func_190916_E() != token.func_190916_E()) continue;
            return;
        }
        UPGRADE_TOKENS.add(token);
    }

    public static boolean stackIsValidUpgradeToken(ItemStack stack) {
        for (ItemStack tokenStack : UPGRADE_TOKENS) {
            if (tokenStack.func_77973_b() != stack.func_77973_b() || tokenStack.func_77960_j() != Short.MAX_VALUE && tokenStack.func_77960_j() != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static void cleanupUpgradeTokens() {
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        block0: for (ItemStack token : UPGRADE_TOKENS) {
            for (UpgradeRecipe recipe : UPGRADE_RECIPES) {
                if (!recipe.upgradeTokenIsValid(token)) continue;
                continue block0;
            }
            toRemove.add(token);
        }
        UPGRADE_TOKENS.removeAll(toRemove);
    }
}

