/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util;

import com.shultrea.rin.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public abstract class PotionUtil {
    public static final Random RANDOM = new Random();
    public static final List<Potion> BUFFS = new ArrayList<Potion>();
    public static final List<Potion> DEBUFFS = new ArrayList<Potion>();

    @Nullable
    public static Potion getNegativePotion(Random rand) {
        if (DEBUFFS.isEmpty()) {
            return null;
        }
        return DEBUFFS.get(rand.nextInt(DEBUFFS.size()));
    }

    @Nullable
    public static Potion getPositivePotion(Random rand) {
        if (BUFFS.isEmpty()) {
            return null;
        }
        return BUFFS.get(rand.nextInt(BUFFS.size()));
    }

    public static void initializePotionLists() {
        ArrayList<ResourceLocation> potionBlacklist = new ArrayList<ResourceLocation>();
        for (String str : ModConfig.miscellaneous.potionBlacklist) {
            if ((str = str.trim()).isEmpty()) continue;
            ResourceLocation loc = new ResourceLocation(str);
            potionBlacklist.add(loc);
        }
        for (Potion potion : Potion.field_188414_b) {
            ResourceLocation potionResource = potion.getRegistryName();
            boolean listMatch = potionBlacklist.contains(potionResource);
            if (listMatch != ModConfig.miscellaneous.potionBlacklistAsWhitelist) continue;
            if (potion.func_76398_f()) {
                DEBUFFS.add(potion);
                continue;
            }
            BUFFS.add(potion);
        }
    }
}

