/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util;

import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.curses.EnchantmentPandorasCurse;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EnchantUtil {
    public static final Random RANDOM = new Random();
    private static List<Enchantment> CURSES = null;

    public static List<Enchantment> getCurses() {
        if (CURSES == null) {
            CURSES = new ArrayList<Enchantment>();
            for (Enchantment e : Enchantment.field_185264_b) {
                if (!e.func_190936_d() || e instanceof EnchantmentPandorasCurse || e instanceof EnchantmentBase && !((EnchantmentBase)e).isEnabled()) continue;
                CURSES.add(e);
            }
        }
        return CURSES;
    }

    public static boolean canEntitySeeSky(EntityLivingBase attacker) {
        if (attacker == null) {
            return false;
        }
        BlockPos pos = new BlockPos(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
        return attacker.field_70170_p.func_175710_j(pos);
    }

    public static void setRaining(World world) {
        if (!ModConfig.miscellaneous.enableWeatherChanges) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int i = (300 + RANDOM.nextInt(600)) * 20;
        world.func_72912_H().func_176142_i(0);
        world.func_72912_H().func_76080_g(i);
        world.func_72912_H().func_76090_f(i);
        world.func_72912_H().func_76084_b(true);
        world.func_72912_H().func_76069_a(false);
    }

    public static void setThundering(World world) {
        if (!ModConfig.miscellaneous.enableWeatherChanges) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int i = (300 + RANDOM.nextInt(600)) * 20;
        world.func_72912_H().func_176142_i(0);
        world.func_72912_H().func_76080_g(i);
        world.func_72912_H().func_76090_f(i);
        world.func_72912_H().func_76084_b(true);
        world.func_72912_H().func_76069_a(true);
    }

    public static void setClearWeather(World world) {
        if (!ModConfig.miscellaneous.enableWeatherChanges) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int i = (300 + RANDOM.nextInt(600)) * 20;
        world.func_72912_H().func_176142_i(i);
        world.func_72912_H().func_76080_g(0);
        world.func_72912_H().func_76090_f(0);
        world.func_72912_H().func_76084_b(false);
        world.func_72912_H().func_76069_a(false);
    }

    public static void knockBackIgnoreKBRes(Entity entityIn, float strength, double xRatio, double zRatio) {
        entityIn.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)Math.max((double)0.1f, xRatio * xRatio + zRatio * zRatio));
        entityIn.field_70159_w /= 2.0;
        entityIn.field_70179_y /= 2.0;
        entityIn.field_70159_w -= xRatio / (double)f * (double)strength;
        entityIn.field_70179_y -= zRatio / (double)f * (double)strength;
        if (!Double.isFinite(entityIn.field_70159_w)) {
            entityIn.field_70159_w = 0.0;
        }
        if (!Double.isFinite(entityIn.field_70179_y)) {
            entityIn.field_70179_y = 0.0;
        }
        if (entityIn.field_70122_E) {
            entityIn.field_70181_x /= 2.0;
            entityIn.field_70181_x += (double)strength;
            if (entityIn.field_70181_x > 0.4) {
                entityIn.field_70181_x = 0.4;
            }
        }
        if (!Double.isFinite(entityIn.field_70181_x)) {
            entityIn.field_70181_x = 0.0;
        }
        entityIn.field_70133_I = true;
    }

    public static boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase entity) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    public static int getTotalArmorEnchantmentLevel(Enchantment enchantment, EntityLivingBase user) {
        List list = enchantment.func_185260_a(user);
        if (list.isEmpty()) {
            return 0;
        }
        int enchantLevelSum = 0;
        for (ItemStack itemstack : list) {
            if (itemstack.func_190926_b()) continue;
            enchantLevelSum += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack);
        }
        return enchantLevelSum;
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers) {
        float f = MathHelper.func_76131_a((float)(enchantModifiers * 1.5f), (float)0.0f, (float)60.0f);
        return damage * (1.0f - f / 80.0f);
    }
}

