/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.properties;

import com.shultrea.rin.properties.ArrowPropertiesProvider;
import com.shultrea.rin.properties.IArrowProperties;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.IEntityDamageSourceMixin;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.SpartanWeaponryCompat;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArrowPropertiesHandler {
    private static final ResourceLocation ARROWPROPERTIES_CAP_RESOURCE = new ResourceLocation("somanyenchantments:arrow_capabilities");
    private static final Random RANDOM = new Random();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityArrow && !((Entity)event.getObject()).hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)) {
            event.addCapability(ARROWPROPERTIES_CAP_RESOURCE, (ICapabilityProvider)new ArrowPropertiesProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityArrow)) {
            return;
        }
        EntityArrow entityArrow = (EntityArrow)event.getEntity();
        if (!(entityArrow.field_70250_c instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase shooter = (EntityLivingBase)entityArrow.field_70250_c;
        ItemStack bow = shooter.func_184614_ca();
        if (!(bow.func_77973_b() instanceof ItemBow || CompatUtil.isSpartanWeaponryLoaded() && SpartanWeaponryCompat.itemIsCrossbow(bow.func_77973_b()))) {
            bow = shooter.func_184592_cb();
        }
        if (!(bow.func_77973_b() instanceof ItemBow || CompatUtil.isSpartanWeaponryLoaded() && SpartanWeaponryCompat.itemIsCrossbow(bow.func_77973_b()))) {
            return;
        }
        IArrowProperties properties = (IArrowProperties)entityArrow.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null);
        if (properties == null) {
            return;
        }
        if (properties.getPropertiesHandled()) {
            return;
        }
        ArrowPropertiesHandler.setArrowEnchantmentsFromStack(bow, entityArrow, properties);
        properties.setPropertiesHandled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onArrowHitHurt(LivingHurtEvent event) {
        int pierceLevel;
        if (!(event.getSource().func_76364_f() instanceof EntityArrow)) {
            return;
        }
        if (!"arrow".equals(event.getSource().field_76373_n)) {
            return;
        }
        EntityArrow arrow = (EntityArrow)event.getSource().func_76364_f();
        EntityLivingBase victim = event.getEntityLiving();
        IArrowProperties properties = (IArrowProperties)arrow.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null);
        if (properties == null) {
            return;
        }
        if (EnchantmentRegistry.runeArrowPiercing.isEnabled() && (pierceLevel = properties.getArmorPiercingLevel()) > 0 && event.getSource() instanceof EntityDamageSource) {
            float currPercent = ((IEntityDamageSourceMixin)event.getSource()).soManyEnchantments$getPiercingPercent();
            float percent = Math.min(currPercent + 0.25f * (float)pierceLevel, 1.0f);
            ((IEntityDamageSourceMixin)event.getSource()).soManyEnchantments$setPiercingPercent(percent);
        }
    }

    @SubscribeEvent
    public void onArrowHitDamage(LivingDamageEvent event) {
        float draggingPower;
        int flameLevel;
        int seconds;
        if (!(event.getSource().func_76364_f() instanceof EntityArrow)) {
            return;
        }
        if (!"arrow".equals(event.getSource().field_76373_n)) {
            return;
        }
        EntityArrow arrow = (EntityArrow)event.getSource().func_76364_f();
        EntityLivingBase victim = event.getEntityLiving();
        IArrowProperties properties = (IArrowProperties)arrow.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null);
        if (properties == null) {
            return;
        }
        if ((EnchantmentRegistry.lesserFlame.isEnabled() || EnchantmentRegistry.advancedFlame.isEnabled() || EnchantmentRegistry.supremeFlame.isEnabled()) && (seconds = ArrowPropertiesHandler.getFireSeconds(properties.getFlameLevel())) > 0) {
            victim.func_70015_d(seconds);
        }
        if (EnchantmentRegistry.extinguish.isEnabled() && (flameLevel = properties.getFlameLevel()) == -1) {
            victim.func_70066_B();
        }
        if (EnchantmentRegistry.dragging.isEnabled() && (draggingPower = properties.getDraggingPower()) > 0.0f) {
            double velocityMultiplier = -0.6f * draggingPower / MathHelper.func_76133_a((double)(arrow.field_70159_w * arrow.field_70159_w + arrow.field_70179_y * arrow.field_70179_y));
            victim.func_70024_g(arrow.field_70159_w * velocityMultiplier, 0.1, arrow.field_70179_y * velocityMultiplier);
            victim.field_70133_I = true;
        }
        if (EnchantmentRegistry.strafe.isEnabled() && properties.getArrowResetsIFrames()) {
            victim.field_70172_ad = 0;
        }
    }

    private static int getFireSeconds(int tier) {
        switch (tier) {
            case 1: {
                return 2;
            }
            case 2: {
                return 15;
            }
            case 3: {
                return 30;
            }
        }
        return 0;
    }

    public static void setArrowEnchantmentsFromStack(ItemStack bow, EntityArrow arrow, IArrowProperties properties) {
        int levelExtinguish;
        int levelSupFlame;
        int levelAdvFlame;
        int levelLessFlame;
        int draggingLevel;
        int runeArrowPiercingLevel;
        int advPunchLevel;
        int advPowerLevel;
        int powerlessLevel;
        if (EnchantmentRegistry.powerless.isEnabled() && (powerlessLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.powerless, (ItemStack)bow)) > 0) {
            arrow.func_70239_b(arrow.func_70242_d() - 0.5 - (double)powerlessLevel * 0.5);
            if (powerlessLevel > 2 || RANDOM.nextFloat() < (float)powerlessLevel * 0.4f) {
                arrow.func_70243_d(false);
            }
        }
        if (EnchantmentRegistry.advancedPower.isEnabled() && (advPowerLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedPower, (ItemStack)bow)) > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + 1.25 + (double)advPowerLevel * 0.75);
            if (advPowerLevel >= 4 || RANDOM.nextFloat() < (float)advPowerLevel * 0.25f) {
                arrow.func_70243_d(true);
            }
        }
        if (EnchantmentRegistry.advancedPunch.isEnabled() && (advPunchLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedPunch, (ItemStack)bow)) > 0) {
            arrow.func_70240_a(1 + advPunchLevel * 2);
        }
        if (EnchantmentRegistry.runeArrowPiercing.isEnabled() && (runeArrowPiercingLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.runeArrowPiercing, (ItemStack)bow)) > 0) {
            properties.setArmorPiercingLevel(runeArrowPiercingLevel);
        }
        if (EnchantmentRegistry.dragging.isEnabled() && (draggingLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.dragging, (ItemStack)bow)) > 0) {
            properties.setDraggingPower(1.25f + (float)draggingLevel * 1.75f);
        }
        if (EnchantmentRegistry.strafe.isEnabled()) {
            int levelStrafe = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.strafe, (ItemStack)bow);
            if (RANDOM.nextFloat() < 0.125f * (float)levelStrafe) {
                properties.setArrowResetsIFrames(true);
            }
        }
        if (EnchantmentRegistry.lesserFlame.isEnabled() && (levelLessFlame = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.lesserFlame, (ItemStack)bow)) > 0) {
            properties.setFlameLevel(1);
        }
        if (EnchantmentRegistry.advancedFlame.isEnabled() && (levelAdvFlame = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedFlame, (ItemStack)bow)) > 0) {
            arrow.func_70015_d(200);
            properties.setFlameLevel(2);
        }
        if (EnchantmentRegistry.supremeFlame.isEnabled() && (levelSupFlame = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.supremeFlame, (ItemStack)bow)) > 0) {
            arrow.func_70015_d(400);
            properties.setFlameLevel(3);
        }
        if (EnchantmentRegistry.extinguish.isEnabled() && (levelExtinguish = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.extinguish, (ItemStack)bow)) > 0) {
            arrow.func_70066_B();
            properties.setFlameLevel(-1);
        }
    }
}

