/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.mixin.vanilla.upgrading;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.shultrea.rin.SoManyEnchantments;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.util.IContainerEnchantmentMixin;
import com.shultrea.rin.util.UpgradeRecipe;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ContainerEnchantment.class})
public abstract class ContainerEnchantmentMixin
extends Container
implements IContainerEnchantmentMixin {
    @Shadow
    public IInventory field_75168_e;
    @Shadow
    public int[] field_75167_g;
    @Shadow
    public int[] field_185001_h;
    @Shadow
    public int[] field_185002_i;
    @Shadow
    @Final
    private World field_75172_h;
    @Shadow
    @Final
    private BlockPos field_178150_j;
    @Shadow
    @Final
    private Random field_75169_l;
    @Shadow
    public int field_178149_f;
    @Unique
    private final UpgradeRecipe[] soManyEnchantments$currentRecipes = new UpgradeRecipe[3];
    @Unique
    private IInventory soManyEnchantments$upgradeTokenInventory;
    @Unique
    private int soManyEnchantments$bookshelfPower = 0;
    @Unique
    private boolean soManyEnchantments$tokenIsLapis = false;
    @Unique
    private final boolean[] soManyEnchantments$tokenIsCorrect = new boolean[3];

    @Shadow
    public abstract void func_75142_b();

    @WrapOperation(method={"<init>(Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/ContainerEnchantment;addSlotToContainer(Lnet/minecraft/inventory/Slot;)Lnet/minecraft/inventory/Slot;", ordinal=1)})
    private Slot soManyEnchantments_vanillaContainerEnchantment_init(ContainerEnchantment instance, Slot slot, Operation<Slot> original) {
        if (slot.getSlotIndex() == 1 && slot.field_75223_e == 35 && slot.field_75221_f == 47) {
            return original.call(instance, new Slot(this.field_75168_e, 1, 35, 47){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return ContainerEnchantmentMixin.soManyEnchantments$isTokenLapis(stack) || UpgradeRecipe.stackIsValidUpgradeToken(stack);
                }
            });
        }
        return original.call(instance, slot);
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/player/InventoryPlayer;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="TAIL")})
    private void setSoManyEnchantments_vanillaContainerEnchantment_init_addTokenSlots(InventoryPlayer playerInv, World worldIn, BlockPos pos, CallbackInfo ci) {
        this.soManyEnchantments$upgradeTokenInventory = new InventoryBasic("Upgrade Tokens", true, 3);
        for (int i = 0; i < 3; ++i) {
            this.func_75146_a(new Slot(this.soManyEnchantments$upgradeTokenInventory, i, 61, 15 + i * 19){

                public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
                    return false;
                }

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return false;
                }

                @SideOnly(value=Side.CLIENT)
                public boolean func_111238_b() {
                    return false;
                }
            });
        }
    }

    @Unique
    private void soManyEnchantments$setUpgradeToken(ItemStack stack, int slotId) {
        Slot slot = this.func_75147_a(this.soManyEnchantments$upgradeTokenInventory, slotId);
        if (slot != null) {
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                slot.func_75215_d(new ItemStack(stack.func_77973_b(), stack.func_190916_E(), 0));
            } else {
                slot.func_75215_d(stack);
            }
        } else {
            SoManyEnchantments.LOGGER.warn("Unable to find Upgrade Token Slot with id {}", (Object)slotId);
        }
    }

    @Inject(method={"broadcastData"}, at={@At(value="RETURN")})
    private void soManyEnchantments_vanillaContainerEnchantment_broadcastData(IContainerListener crafting, CallbackInfo ci) {
        ContainerEnchantment thisContainer = (ContainerEnchantment)this;
        crafting.func_71112_a((Container)thisContainer, 10, this.soManyEnchantments$bookshelfPower);
        crafting.func_71112_a((Container)thisContainer, 11, this.soManyEnchantments$tokenIsLapis ? 1 : 0);
        crafting.func_71112_a((Container)thisContainer, 12, this.soManyEnchantments$tokenIsCorrect[0] ? 1 : 0);
        crafting.func_71112_a((Container)thisContainer, 13, this.soManyEnchantments$tokenIsCorrect[1] ? 1 : 0);
        crafting.func_71112_a((Container)thisContainer, 14, this.soManyEnchantments$tokenIsCorrect[2] ? 1 : 0);
    }

    @Inject(method={"updateProgressBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_updateProgressBar(int id, int data, CallbackInfo ci) {
        switch (id) {
            case 10: {
                this.soManyEnchantments$bookshelfPower = data;
                ci.cancel();
                break;
            }
            case 11: {
                this.soManyEnchantments$tokenIsLapis = data == 1;
                ci.cancel();
                break;
            }
            case 12: {
                this.soManyEnchantments$tokenIsCorrect[0] = data == 1;
                ci.cancel();
                break;
            }
            case 13: {
                this.soManyEnchantments$tokenIsCorrect[1] = data == 1;
                ci.cancel();
                break;
            }
            case 14: {
                this.soManyEnchantments$tokenIsCorrect[2] = data == 1;
                ci.cancel();
            }
        }
    }

    @Inject(method={"onCraftMatrixChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/IInventory;getStackInSlot(I)Lnet/minecraft/item/ItemStack;")})
    private void soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_resetTokenValues(IInventory inventoryIn, CallbackInfo ci, @Share(value="tokenItem") LocalRef<ItemStack> tokenItem) {
        tokenItem.set(inventoryIn.func_70301_a(1));
        this.soManyEnchantments$tokenIsLapis = ContainerEnchantmentMixin.soManyEnchantments$isTokenLapis(tokenItem.get());
        this.soManyEnchantments$tokenIsCorrect[0] = false;
        this.soManyEnchantments$tokenIsCorrect[1] = false;
        this.soManyEnchantments$tokenIsCorrect[2] = false;
    }

    @Inject(method={"onCraftMatrixChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z")}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_earlyReturn(IInventory inventoryIn, CallbackInfo ci, @Local ItemStack targetItem, @Share(value="itemIsEnchantable") LocalBooleanRef itemIsEnchantable, @Share(value="itemIsUpgradeable") LocalBooleanRef itemIsUpgradeable) {
        itemIsEnchantable.set(targetItem.func_77956_u());
        itemIsUpgradeable.set(!(!targetItem.func_77948_v() && targetItem.func_77973_b() != Items.field_151134_bR || !ModConfig.upgrade.allowLevelUpgrades && !ModConfig.upgrade.allowTierUpgrades));
        if (targetItem.func_190926_b() || !itemIsEnchantable.get() && !itemIsUpgradeable.get()) {
            ci.cancel();
            this.soManyEnchantments$resetValues();
        }
    }

    @WrapOperation(method={"onCraftMatrixChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isItemEnchantable()Z")})
    private boolean soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_allowUpgradingGenerally(ItemStack targetItem, Operation<Boolean> original, @Share(value="itemIsUpgradeable") LocalBooleanRef itemIsUpgradeable) {
        return original.call(targetItem) != false || itemIsUpgradeable.get();
    }

    @ModifyExpressionValue(method={"onCraftMatrixChanged"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;isRemote:Z")})
    private boolean soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_resetValues(boolean original) {
        if (!original) {
            this.soManyEnchantments$resetValues();
        }
        return original;
    }

    @ModifyVariable(method={"onCraftMatrixChanged"}, at=@At(value="STORE"), name={"power"})
    private float soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_saveBookshelfPower(float original, @Share(value="bookshelfPower") LocalFloatRef bookshelfPower) {
        bookshelfPower.set(original);
        return original;
    }

    @Inject(method={"onCraftMatrixChanged"}, at={@At(value="FIELD", target="Lnet/minecraft/inventory/ContainerEnchantment;rand:Ljava/util/Random;", ordinal=0)}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_onCraftMatrixChanged_upgrading(IInventory inventoryIn, CallbackInfo ci, @Share(value="bookshelfPower") LocalFloatRef bookshelfPower, @Share(value="itemIsEnchantable") LocalBooleanRef itemIsEnchantable, @Share(value="itemIsUpgradeable") LocalBooleanRef itemIsUpgradeable, @Share(value="tokenItem") LocalRef<ItemStack> tokenItem) {
        ItemStack targetItem = inventoryIn.func_70301_a(0);
        if (itemIsEnchantable.get()) {
            return;
        }
        if (!itemIsUpgradeable.get()) {
            ci.cancel();
            return;
        }
        if (ModConfig.upgrade.onlyAllowOnBooks && targetItem.func_77973_b() != Items.field_151134_bR) {
            this.func_75142_b();
            ci.cancel();
            return;
        }
        ArrayList<UpgradeRecipe> upgradeRecipes = new ArrayList<UpgradeRecipe>();
        ArrayList<Integer> upgradeLevels = new ArrayList<Integer>();
        for (UpgradeRecipe recipe : UpgradeRecipe.UPGRADE_RECIPES) {
            int upgradedLevel = recipe.canUpgrade(targetItem);
            if (upgradedLevel == -99) continue;
            upgradeRecipes.add(recipe);
            upgradeLevels.add(upgradedLevel);
        }
        if (upgradeRecipes.isEmpty()) {
            this.func_75142_b();
            ci.cancel();
            return;
        }
        this.field_75169_l.setSeed(this.field_178149_f);
        for (int i = 0; i < 3; ++i) {
            int levelCost;
            if (upgradeRecipes.isEmpty()) {
                this.soManyEnchantments$currentRecipes[i] = null;
                this.soManyEnchantments$setUpgradeToken(ItemStack.field_190927_a, i);
                continue;
            }
            int randomIndex = this.field_75169_l.nextInt(upgradeRecipes.size());
            UpgradeRecipe pickedRecipe = (UpgradeRecipe)upgradeRecipes.get(randomIndex);
            int pickedLevel = (Integer)upgradeLevels.get(randomIndex);
            upgradeRecipes.remove(randomIndex);
            upgradeLevels.remove(randomIndex);
            this.soManyEnchantments$tokenIsCorrect[i] = pickedRecipe.upgradeTokenIsValid(tokenItem.get());
            switch (ModConfig.upgrade.levelCostMode) {
                case 0: {
                    levelCost = 1;
                    break;
                }
                case 2: {
                    levelCost = pickedRecipe.getOutputEnchant().func_77321_a(pickedLevel);
                    break;
                }
                default: {
                    levelCost = pickedLevel * ContainerEnchantmentMixin.soManyEnchantments$getRarityMultiplier(pickedRecipe.getOutputEnchant().func_77324_c(), targetItem.func_77973_b() == Items.field_151134_bR);
                }
            }
            this.field_75167_g[i] = levelCost = (int)(ModConfig.upgrade.levelCostMultiplier * (float)levelCost);
            this.field_185001_h[i] = ModConfig.upgrade.allowEnchantmentClues ? Enchantment.func_185258_b((Enchantment)pickedRecipe.getOutputEnchant()) : -1;
            this.field_185002_i[i] = ModConfig.upgrade.allowEnchantmentClues ? pickedLevel : -1;
            this.soManyEnchantments$currentRecipes[i] = pickedRecipe;
            this.soManyEnchantments$setUpgradeToken(pickedRecipe.getTokenCost(), i);
        }
        this.soManyEnchantments$bookshelfPower = (int)bookshelfPower.get();
        this.func_75142_b();
        ci.cancel();
    }

    @Unique
    private void soManyEnchantments$resetValues() {
        for (int i = 0; i < 3; ++i) {
            this.field_75167_g[i] = 0;
            this.field_185001_h[i] = -1;
            this.field_185002_i[i] = -1;
            this.soManyEnchantments$currentRecipes[i] = null;
            this.soManyEnchantments$setUpgradeToken(ItemStack.field_190927_a, i);
        }
        this.soManyEnchantments$bookshelfPower = 0;
    }

    @Inject(method={"enchantItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=0)}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_enchantItem_sanityChecks(EntityPlayer playerIn, int id, CallbackInfoReturnable<Boolean> cir, @Local(name={"itemstack"}) ItemStack targetItem) {
        if (id < 0 || id > 2) {
            cir.setReturnValue(false);
        }
        if (targetItem.func_190926_b()) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"enchantItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;isRemote:Z")}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_enchantItem_preventDoubleEnchanting(EntityPlayer playerIn, int id, CallbackInfoReturnable<Boolean> cir, @Local(name={"itemstack"}) ItemStack targetItem) {
        if (!targetItem.func_77956_u()) {
            cir.setReturnValue(false);
        }
    }

    @WrapOperation(method={"enchantItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=0)})
    private boolean soManyEnchantments_vanillaContainerEnchantment_enchantItem_switchToUpgrading(ItemStack instance, Operation<Boolean> original, @Local(name={"itemstack"}) ItemStack targetItem, @Local(name={"itemstack1"}) ItemStack tokenItem, @Local(argsOnly=true) int id, @Local(argsOnly=true) EntityPlayer playerIn, @Cancellable CallbackInfoReturnable<Boolean> cir) {
        if (this.soManyEnchantments$getUpgradeTokenCost(id).func_190926_b()) {
            return original.call(instance) != false || !this.soManyEnchantments$tokenIsLapis;
        }
        boolean isCreative = playerIn.field_71075_bZ.field_75098_d;
        if (!isCreative && this.soManyEnchantments$bookshelfPower < ModConfig.upgrade.bookshelvesNeeded) {
            cir.setReturnValue(false);
            return true;
        }
        int xpCost = this.field_75167_g[id];
        if (xpCost <= 0 || !isCreative && playerIn.field_71068_ca < xpCost) {
            cir.setReturnValue(false);
            return true;
        }
        if (!this.field_75172_h.field_72995_K) {
            NBTTagCompound tag;
            UpgradeRecipe usedRecipe = this.soManyEnchantments$currentRecipes[id].getUsedRecipe(this.field_75172_h.field_73012_v, false);
            if (usedRecipe == null) {
                cir.setReturnValue(false);
                return true;
            }
            if (!(isCreative || !tokenItem.func_190926_b() && usedRecipe.upgradeTokenIsValid(tokenItem))) {
                cir.setReturnValue(false);
                return true;
            }
            Map<Enchantment, Integer> resultingEnchants = usedRecipe.getOutputStackEnchants(targetItem);
            if (targetItem.func_77973_b() == Items.field_151134_bR && (tag = targetItem.func_77978_p()) != null) {
                tag.func_74782_a("StoredEnchantments", (NBTBase)new NBTTagList());
                targetItem.func_77982_d(tag);
            }
            EnchantmentHelper.func_82782_a(resultingEnchants, (ItemStack)targetItem);
            playerIn.func_192024_a(targetItem, xpCost);
            if (!isCreative) {
                tokenItem.func_190918_g(usedRecipe.getTokenCost().func_190916_E());
                if (tokenItem.func_190926_b()) {
                    this.field_75168_e.func_70299_a(1, ItemStack.field_190927_a);
                }
            }
            if (ModConfig.upgrade.anvilRepairMode > 0) {
                int repairCost = targetItem.func_82838_A();
                switch (ModConfig.upgrade.anvilRepairMode) {
                    case 2: {
                        repairCost = (int)((float)repairCost + ModConfig.upgrade.anvilRepairCostAmount);
                        break;
                    }
                    case 3: {
                        repairCost = (int)((float)repairCost * ModConfig.upgrade.anvilRepairCostAmount);
                        break;
                    }
                    default: {
                        repairCost = 1 + 2 * repairCost;
                    }
                }
                targetItem.func_82841_c(repairCost);
            }
            this.field_75168_e.func_70296_d();
            this.field_178149_f = playerIn.func_175138_ci();
            this.func_75130_a(this.field_75168_e);
            this.field_75172_h.func_184133_a(null, this.field_178150_j, usedRecipe.getIsCursingRecipe() ? SoundEvents.field_187646_bt : SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, this.field_75172_h.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        cir.setReturnValue(true);
        return true;
    }

    @Inject(method={"transferStackInSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;", ordinal=0)}, cancellable=true)
    private void soManyEnchantments_vanillaContainerEnchantment_transferStackInSlot_alsoAllowUpgradeTokens(EntityPlayer playerIn, int index, CallbackInfoReturnable<ItemStack> cir, @Local(name={"itemstack1"}) ItemStack itemstack1) {
        if ((ContainerEnchantmentMixin.soManyEnchantments$isTokenLapis(itemstack1) || UpgradeRecipe.stackIsValidUpgradeToken(itemstack1)) && !this.func_75135_a(itemstack1, 1, 2, true)) {
            cir.setReturnValue(ItemStack.field_190927_a);
        }
    }

    @Unique
    private static boolean soManyEnchantments$isTokenLapis(ItemStack tokenStack) {
        return OreDictionary.getOres((String)"gemLapis").stream().anyMatch(ore -> OreDictionary.itemMatches((ItemStack)ore, (ItemStack)tokenStack, (boolean)false));
    }

    @Unique
    private static int soManyEnchantments$getRarityMultiplier(Enchantment.Rarity rarity, boolean isBook) {
        switch (rarity) {
            case COMMON: {
                return 1;
            }
            case UNCOMMON: {
                return isBook ? 1 : 2;
            }
            case RARE: {
                return isBook ? 2 : 4;
            }
            case VERY_RARE: {
                return isBook ? 4 : 8;
            }
        }
        return 0;
    }

    @Override
    @Unique
    public ItemStack soManyEnchantments$getUpgradeTokenCost(int slotId) {
        return this.func_75147_a(this.soManyEnchantments$upgradeTokenInventory, slotId).func_75211_c();
    }

    @Override
    @Unique
    public int soManyEnchantments$getBookshelfPower() {
        return this.soManyEnchantments$bookshelfPower;
    }

    @Override
    @Unique
    public boolean soManyEnchantments$getTokenIsLapis() {
        return this.soManyEnchantments$tokenIsLapis;
    }

    @Override
    @Unique
    public boolean soManyEnchantments$getIsValidAndEnoughToken(int id) {
        return this.soManyEnchantments$tokenIsCorrect[id];
    }
}

