/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.mixin.vanilla;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.curses.EnchantmentDragging;
import com.shultrea.rin.enchantments.curses.EnchantmentExtinguish;
import com.shultrea.rin.enchantments.fishing.EnchantmentAdvancedLuckOfTheSea;
import com.shultrea.rin.enchantments.fishing.EnchantmentAdvancedLure;
import com.shultrea.rin.enchantments.tool.EnchantmentAdvancedEfficiency;
import com.shultrea.rin.enchantments.weapon.EnchantmentAdvancedKnockback;
import com.shultrea.rin.enchantments.weapon.EnchantmentAdvancedLooting;
import com.shultrea.rin.enchantments.weapon.EnchantmentFieryEdge;
import com.shultrea.rin.enchantments.weapon.EnchantmentTierFA;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentHelper.class}, priority=2000)
public abstract class EnchantmentHelperMixin {
    @Inject(method={"applyArthropodEnchantments"}, at={@At(value="HEAD")})
    private static void soManyEnchantments_vanillaEnchantmentHelper_applyArthropodEnchantments(EntityLivingBase user, Entity target, CallbackInfo ci) {
        if (user != null) {
            ItemStack stack = user.func_184614_ca();
            if (CompatUtil.isRLCombatLoaded()) {
                stack = RLCombatCompat.getArthropodStack(user);
            }
            if (!stack.func_190926_b()) {
                NBTTagList nbttaglist = stack.func_77986_q();
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    EnchantmentBase enchant;
                    short enchID = nbttaglist.func_150305_b(i).func_74765_d("id");
                    short enchLvl = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                    Enchantment ench = Enchantment.func_185262_c((int)enchID);
                    if (ench == null || !(ench instanceof EnchantmentBase) || !(enchant = (EnchantmentBase)ench).isEnabled()) continue;
                    enchant.onEntityDamagedAlt(user, target, stack, enchLvl);
                }
            }
        }
    }

    @ModifyReturnValue(method={"getKnockbackModifier"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getKnockbackModifier(int original, EntityLivingBase entity) {
        boolean hasDragging = EnchantmentDragging.getLevelValue(entity) > 0;
        return hasDragging ? 0 : original + EnchantmentAdvancedKnockback.getLevelValue(entity);
    }

    @ModifyReturnValue(method={"getFireAspectModifier"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getFireAspectModifier(int original, EntityLivingBase entity) {
        boolean hasExtinguish = EnchantmentExtinguish.getLevelValue(entity) > 0;
        return hasExtinguish ? 0 : original + EnchantmentTierFA.getLevelValue(entity) + EnchantmentFieryEdge.getLevelValue(entity);
    }

    @ModifyReturnValue(method={"getEfficiencyModifier"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getEfficiencyModifier(int original, EntityLivingBase entity) {
        return original + EnchantmentAdvancedEfficiency.getLevelValue(entity);
    }

    @ModifyReturnValue(method={"getFishingLuckBonus"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getFishingLuckBonus(int original, ItemStack stack) {
        return original + EnchantmentAdvancedLuckOfTheSea.getLevelValue(stack);
    }

    @ModifyReturnValue(method={"getFishingSpeedBonus"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getFishingSpeedBonus(int original, ItemStack stack) {
        return original + EnchantmentAdvancedLure.getLevelValue(stack);
    }

    @ModifyReturnValue(method={"getLootingModifier"}, at={@At(value="RETURN")})
    private static int soManyEnchantments_vanillaEnchantmentHelper_getLootingModifier(int original, EntityLivingBase entity) {
        return original + EnchantmentAdvancedLooting.getLevelValue(entity);
    }
}

