/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.mixin.vanilla;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.util.FromEnchTableThreadLocal;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnchantmentHelper.class}, priority=2000)
public abstract class EnchantmentHelperEnchantBlacklistMixin {
    @ModifyExpressionValue(method={"buildEnchantmentList"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;getEnchantmentDatas(ILnet/minecraft/item/ItemStack;Z)Ljava/util/List;")})
    private static List<EnchantmentData> soManyEnchantments_vanillaEnchantmentHelper_buildEnchantmentList(List<EnchantmentData> original, @Local(argsOnly=true) int level, @Local(argsOnly=true) ItemStack stack, @Local(argsOnly=true) boolean allowTreasure) {
        boolean fromEnchantingTable = FromEnchTableThreadLocal.getAndRemove();
        return original.stream().filter(e -> EnchantmentHelperEnchantBlacklistMixin.soManyEnchantments$enchantmentIsAllowed(e, fromEnchantingTable)).collect(Collectors.toList());
    }

    @Unique
    private static boolean soManyEnchantments$enchantmentIsAllowed(EnchantmentData data, boolean fromEnchantingTable) {
        if (fromEnchantingTable) {
            return ConfigProvider.getEnchantTableEnchantsBlacklist().contains(data.field_76302_b) == ModConfig.miscellaneous.blacklistedEnchTableEnchantsIsWhitelist;
        }
        return ConfigProvider.getRandomLevelEnchantsBlacklist().contains(data.field_76302_b) == ModConfig.miscellaneous.blacklistedRandomLevelEnchantsIsWhitelist;
    }
}

