/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.weather;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.EnchantUtil;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentWintersGrace
extends EnchantmentBase {
    public EnchantmentWintersGrace(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.wintersGrace;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.wintersGrace;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.wintersGrace, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.wintersGrace, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.wintersGrace, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.wintersGrace, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.wintersGrace;
    }

    public int level(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.wintersGrace, (ItemStack)stack);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0 && EnchantmentWintersGrace.isInColdTemperature(attacker)) {
            float dmg = 2.0f + 1.5f * (float)level;
            if (!attacker.field_70170_p.func_72896_J()) {
                dmg -= 0.5f + 0.25f * (float)level;
            }
            if (!EnchantUtil.canEntitySeeSky(attacker)) {
                dmg -= 0.5f + 0.75f * (float)level;
            }
            float strengthMulti = CompatUtil.isRLCombatLoaded() ? RLCombatCompat.getAttackEntityFromStrength() : 1.0f;
            event.setAmount(event.getAmount() + dmg * strengthMulti);
            if (attacker.func_70681_au().nextFloat() < 0.04f * (float)level * strengthMulti) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 20 + 10 * level, Math.max(0, level - 3)));
                if (level > 3) {
                    victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 + 10 * level, Math.max(0, level - 4)));
                }
            }
        }
    }

    private static boolean isInColdTemperature(EntityLivingBase attacker) {
        BlockPos pos = new BlockPos(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
        float temp = attacker.field_70170_p.func_180494_b(pos).func_180626_a(pos);
        return temp <= 0.3f;
    }
}

