/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.weather;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.EnchantUtil;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentLunasBlessing
extends EnchantmentBase {
    public EnchantmentLunasBlessing(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.lunasBlessing;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.lunasBlessing;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lunasBlessing, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lunasBlessing, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.lunasBlessing, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lunasBlessing, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.lunasBlessing;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (weapon.func_190926_b()) {
            return;
        }
        if (!attacker.field_70170_p.field_72995_K && !attacker.field_70170_p.func_72935_r() && EnchantUtil.canEntitySeeSky(attacker)) {
            if (CompatUtil.isRLCombatLoaded() && attacker.func_70681_au().nextFloat() > RLCombatCompat.getOnEntityDamagedAltStrength()) {
                return;
            }
            victim.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 + 10 * level));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            if (attacker.field_70170_p.func_72935_r()) {
                return;
            }
            float dmg = 1.5f + 0.75f * (float)level;
            if (!EnchantUtil.canEntitySeeSky(attacker)) {
                dmg -= 1.0f + 0.5f * (float)level;
            }
            float strengthMulti = CompatUtil.isRLCombatLoaded() ? RLCombatCompat.getAttackEntityFromStrength() : 1.0f;
            event.setAmount(event.getAmount() + dmg * strengthMulti);
        }
    }
}

