/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.subject;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSubjectEnchantments
extends EnchantmentBase {
    private static final int BIOLOGY = 0;
    private static final int CHEMISTRY = 1;
    private static final int ENGLISH = 2;
    private static final int HISTORY = 3;
    private static final int MATHEMATICS = 4;
    private static final int PE = 5;
    private static final int PHYSICS = 6;
    private static final int GEOGRAPHY = 7;
    private final int damageType;

    public EnchantmentSubjectEnchantments(String name, Enchantment.Rarity rarity, int damageTypeIn, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
        this.damageType = damageTypeIn;
    }

    @Override
    public boolean isEnabled() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.enabled.subjectBiology;
            }
            case 1: {
                return ModConfig.enabled.subjectChemistry;
            }
            case 2: {
                return ModConfig.enabled.subjectEnglish;
            }
            case 3: {
                return ModConfig.enabled.subjectHistory;
            }
            case 4: {
                return ModConfig.enabled.subjectMathematics;
            }
            case 5: {
                return ModConfig.enabled.subjectPE;
            }
            case 6: {
                return ModConfig.enabled.subjectPhysics;
            }
            case 7: {
                return ModConfig.enabled.subjectGeography;
            }
        }
        return false;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.level.subjectBiology;
            }
            case 1: {
                return ModConfig.level.subjectChemistry;
            }
            case 2: {
                return ModConfig.level.subjectEnglish;
            }
            case 3: {
                return ModConfig.level.subjectHistory;
            }
            case 4: {
                return ModConfig.level.subjectMathematics;
            }
            case 5: {
                return ModConfig.level.subjectPE;
            }
            case 6: {
                return ModConfig.level.subjectPhysics;
            }
            case 7: {
                return ModConfig.level.subjectGeography;
            }
        }
        return 5;
    }

    @Override
    public int func_77321_a(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectBiology, level);
            }
            case 1: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectChemistry, level);
            }
            case 2: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectEnglish, level);
            }
            case 3: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectHistory, level);
            }
            case 4: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectMathematics, level);
            }
            case 5: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectPE, level);
            }
            case 6: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectPhysics, level);
            }
            case 7: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.subjectGeography, level);
            }
        }
        return 0;
    }

    @Override
    public int func_77317_b(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectBiology, level);
            }
            case 1: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectChemistry, level);
            }
            case 2: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectEnglish, level);
            }
            case 3: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectHistory, level);
            }
            case 4: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectMathematics, level);
            }
            case 5: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectPE, level);
            }
            case 6: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectPhysics, level);
            }
            case 7: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.subjectGeography, level);
            }
        }
        return 0;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectBiology, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectChemistry, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectEnglish, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 3: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectHistory, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 4: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectMathematics, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 5: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectPE, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 6: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectPhysics, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 7: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.subjectGeography, stack) && super.canApplyAtEnchantingTable(stack);
            }
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectBiology, stack) || super.func_92089_a(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectChemistry, stack) || super.func_92089_a(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectEnglish, stack) || super.func_92089_a(stack);
            }
            case 3: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectHistory, stack) || super.func_92089_a(stack);
            }
            case 4: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectMathematics, stack) || super.func_92089_a(stack);
            }
            case 5: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectPE, stack) || super.func_92089_a(stack);
            }
            case 6: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectPhysics, stack) || super.func_92089_a(stack);
            }
            case 7: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.subjectGeography, stack) || super.func_92089_a(stack);
            }
        }
        return false;
    }

    @Override
    public boolean func_185261_e() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.treasure.subjectBiology;
            }
            case 1: {
                return ModConfig.treasure.subjectChemistry;
            }
            case 2: {
                return ModConfig.treasure.subjectEnglish;
            }
            case 3: {
                return ModConfig.treasure.subjectHistory;
            }
            case 4: {
                return ModConfig.treasure.subjectMathematics;
            }
            case 5: {
                return ModConfig.treasure.subjectPE;
            }
            case 6: {
                return ModConfig.treasure.subjectPhysics;
            }
            case 7: {
                return ModConfig.treasure.subjectGeography;
            }
        }
        return true;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        if (weapon.func_190926_b()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && attacker.func_70681_au().nextFloat() > RLCombatCompat.getOnEntityDamagedAltStrength()) {
            return;
        }
        if (this.damageType == 5) {
            if (attacker.func_70681_au().nextFloat() < 0.05f * (float)level) {
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 120 + level * 20, Math.min(3, level - 1)));
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 80 + level * 20, Math.min(3, level - 1)));
                if (level > 2) {
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 60 + level * 20, level - 3));
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 60 + level * 20, level - 3));
                }
                if (level > 4) {
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20 + level * 20, level - 5));
                }
            }
        } else if (this.damageType == 7) {
            EntityLivingBase victim = (EntityLivingBase)target;
            Set types = BiomeDictionary.getTypes((Biome)attacker.field_70170_p.func_180494_b(attacker.func_180425_c()));
            int amp = 1;
            int dur = 200 * level / this.func_77325_b();
            if (types.contains(BiomeDictionary.Type.HOT) || types.contains(BiomeDictionary.Type.NETHER)) {
                target.func_70015_d(level * 2);
            } else if (types.contains(BiomeDictionary.Type.COLD) || types.contains(BiomeDictionary.Type.SNOWY)) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, dur, amp));
                victim.func_70690_d(new PotionEffect(MobEffects.field_76419_f, dur, amp));
            } else if (types.contains(BiomeDictionary.Type.SWAMP)) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_76436_u, dur, amp));
            } else if (types.contains(BiomeDictionary.Type.WASTELAND)) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_76440_q, dur * 2, 0));
            } else if (types.contains(BiomeDictionary.Type.SPOOKY) || types.contains(BiomeDictionary.Type.DEAD)) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_82731_v, dur, amp));
            } else if (types.contains(BiomeDictionary.Type.MAGICAL)) {
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76428_l, dur / 2, 0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            float strengthMulti;
            float f = strengthMulti = CompatUtil.isRLCombatLoaded() ? RLCombatCompat.getAttackEntityFromStrength() : 1.0f;
            if (this.damageType == 0) {
                if (!(victim instanceof EntityLiving)) {
                    return;
                }
                int taskCount = ((EntityLiving)victim).field_70714_bg.field_75782_a.size();
                if (taskCount > 15 - level) {
                    float dmg = Math.min(2.5f * (float)level, 7.5f);
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                }
            } else if (this.damageType == 1) {
                int count = attacker.func_70651_bq().size();
                if (count > 0) {
                    float dmg = Math.min(0.3f * (float)level * (float)count, 6.0f);
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                    if ((double)attacker.func_70681_au().nextFloat() < 0.04 * (double)level) {
                        BlockPos explosionPos = victim.func_180425_c();
                        attacker.field_70170_p.func_72876_a((Entity)attacker, (double)explosionPos.func_177958_n(), (double)explosionPos.func_177956_o(), (double)explosionPos.func_177952_p(), dmg * strengthMulti * 2.0f / 3.0f, false);
                    }
                }
            } else if (this.damageType == 2) {
                int count = victim.func_70005_c_().length();
                if (count > 0) {
                    float dmg = Math.min(0.075f * (float)level * (float)count, 7.5f);
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                }
            } else if (this.damageType == 3) {
                float perc = attacker.field_70170_p.func_175649_E(attacker.func_180425_c()).func_180168_b() / 6.75f;
                if (perc > 0.0f) {
                    float dmg = 1.5f * (float)level * perc;
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                }
            } else if (this.damageType == 4) {
                int count = attacker instanceof EntityPlayer ? ((EntityPlayer)attacker).field_71068_ca / 2 : attacker.field_70173_aa / 600;
                float dmg = 0.25f * (float)level * (float)MathHelper.func_151239_c((int)Math.max(1, count));
                if (dmg > 0.0f) {
                    dmg = Math.min(dmg, 7.5f);
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                }
            } else if (this.damageType == 6) {
                AxisAlignedBB victimAABB = victim.func_174813_aQ();
                AxisAlignedBB attackerAABB = attacker.func_174813_aQ();
                double victimSize = (victimAABB.field_72336_d - victimAABB.field_72340_a) * (victimAABB.field_72337_e - victimAABB.field_72338_b) * (victimAABB.field_72334_f - victimAABB.field_72339_c);
                double attackerSize = (attackerAABB.field_72336_d - attackerAABB.field_72340_a) * (attackerAABB.field_72337_e - attackerAABB.field_72338_b) * (attackerAABB.field_72334_f - attackerAABB.field_72339_c);
                if (victimSize > 0.0 && attackerSize > 0.0) {
                    float perc = (float)(victimSize / attackerSize);
                    if (perc < 1.0f) {
                        perc = 1.0f / perc;
                    }
                    float dmg = Math.min(0.3f * (float)level * perc, 7.5f);
                    event.setAmount(event.getAmount() + dmg * strengthMulti);
                }
            }
        }
    }
}

