/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.potiondebuffer;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.mixin.vanilla.EntityZombieVillagerAccessor;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import com.shultrea.rin.util.compat.SpawnerControlCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;

public class EnchantmentPurification
extends EnchantmentBase {
    public EnchantmentPurification(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.purification;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.purification;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.purification, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.purification, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.purification, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.purification, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.purification;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (victim.field_70128_L || victim.func_110143_aJ() <= 0.0f) {
            return;
        }
        if (weapon.func_190926_b()) {
            return;
        }
        if (victim.func_70662_br() && (!CompatUtil.isRLCombatLoaded() || attacker.func_70681_au().nextFloat() < RLCombatCompat.getOnEntityDamagedAltStrength())) {
            victim.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20 + level * 10, Math.max(0, Math.min(1, level - 1))));
            victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 + level * 10, Math.max(0, Math.min(2, level - 1))));
        }
        if (victim.func_70681_au().nextFloat() <= 0.05f * (float)level && (!CompatUtil.isRLCombatLoaded() || RLCombatCompat.isOnEntityDamagedAltStrong())) {
            EnchantmentPurification.convert(victim);
        }
    }

    private static void convert(EntityLivingBase entity) {
        if (entity instanceof EntityZombieVillager) {
            entity.func_174810_b(true);
            ((EntityZombieVillagerAccessor)entity).invokeFinishConversion();
        } else if (entity instanceof EntityPigZombie) {
            EntityPig pig = new EntityPig(entity.field_70170_p);
            pig.func_82149_j((Entity)entity);
            if (entity.func_70631_g_()) {
                pig.func_70873_a(-24000);
            }
            if (CompatUtil.isSpawnerControlLoaded()) {
                SpawnerControlCompat.increaseSpawnerCount((Entity)entity);
            }
            entity.func_174810_b(true);
            entity.field_70170_p.func_72900_e((Entity)entity);
            pig.func_94061_f(((EntityPigZombie)entity).func_175446_cd());
            if (entity.func_145818_k_()) {
                pig.func_96094_a(entity.func_95999_t());
                pig.func_174805_g(entity.func_174833_aM());
            }
            entity.field_70170_p.func_72838_d((Entity)pig);
            pig.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
            pig.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 1));
            entity.field_70170_p.func_180498_a(null, 1027, new BlockPos((int)pig.field_70165_t, (int)pig.field_70163_u, (int)pig.field_70161_v), 0);
            pig.field_70172_ad = pig.field_70771_an;
        } else if (entity instanceof EntityMagmaCube) {
            EntitySlime slime = new EntitySlime(entity.field_70170_p);
            slime.func_82149_j((Entity)entity);
            NBTTagCompound entityCompound = entity.serializeNBT();
            NBTTagCompound slimeCompound = slime.serializeNBT();
            slimeCompound.func_74768_a("Size", entityCompound.func_74762_e("Size"));
            slime.func_70037_a(slimeCompound);
            if (CompatUtil.isSpawnerControlLoaded()) {
                SpawnerControlCompat.increaseSpawnerCount((Entity)entity);
            }
            entity.func_174810_b(true);
            entity.field_70170_p.func_72900_e((Entity)entity);
            slime.func_94061_f(((EntityMagmaCube)entity).func_175446_cd());
            if (entity.func_145818_k_()) {
                slime.func_96094_a(entity.func_95999_t());
                slime.func_174805_g(entity.func_174833_aM());
            }
            entity.field_70170_p.func_72838_d((Entity)slime);
            slime.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
            slime.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 1));
            entity.field_70170_p.func_180498_a(null, 1027, new BlockPos((int)slime.field_70165_t, (int)slime.field_70163_u, (int)slime.field_70161_v), 0);
            slime.field_70172_ad = slime.field_70771_an;
        }
    }
}

