/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.potiondebuffer;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class EnchantmentEnvenomed
extends EnchantmentBase {
    public EnchantmentEnvenomed(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.envenomed;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.envenomed;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.envenomed, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.envenomed, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.envenomed, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.envenomed, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.envenomed;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (weapon.func_190926_b()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && attacker.func_70681_au().nextFloat() > RLCombatCompat.getOnEntityDamagedAltStrength()) {
            return;
        }
        if (attacker.func_70681_au().nextFloat() <= 0.2f * (float)level) {
            victim.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 40 + 10 * level, level - 1));
            if (level > 2) {
                victim.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 40 + 10 * level, level - 1));
            }
        }
    }
}

