/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.potiondebuffer;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.BlockRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentCryogenic
extends EnchantmentBase {
    public EnchantmentCryogenic(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.cryogenic;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.cryogenic;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.cryogenic, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.cryogenic, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.cryogenic, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.cryogenic, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.cryogenic;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isOnEntityDamagedAltStrong()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (weapon.func_190926_b()) {
            return;
        }
        if (!attacker.field_70170_p.field_72995_K) {
            PotionEffect slowness = victim.func_70660_b(MobEffects.field_76421_d);
            PotionEffect fatigue = victim.func_70660_b(MobEffects.field_76419_f);
            int ampIncrease = target instanceof EntityPlayer ? 1 : 2;
            int slownessAmp = slowness != null ? Math.min(slowness.func_76458_c() + ampIncrease, 3) : ampIncrease - 1;
            int fatigueAmp = fatigue != null ? Math.min(fatigue.func_76458_c() + ampIncrease, 3) : ampIncrease - 1;
            victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, slownessAmp));
            victim.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 80, fatigueAmp));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isAttackEntityFromStrong()) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            PotionEffect slowness = victim.func_70660_b(MobEffects.field_76421_d);
            PotionEffect fatigue = victim.func_70660_b(MobEffects.field_76419_f);
            if (slowness != null && slowness.func_76458_c() >= 1 && fatigue != null && fatigue.func_76458_c() >= 1) {
                victim.func_70066_B();
                if (attacker.func_70681_au().nextFloat() <= 0.1f * (float)level) {
                    event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)level));
                    int range = Math.min(4, (level + 1) / 2);
                    for (BlockPos.MutableBlockPos mutablePosInBox : BlockPos.func_191531_b((int)(-range), (int)(-range), (int)(-range), (int)range, (int)range, (int)range)) {
                        BlockPos freezePos;
                        if (EnchantmentCryogenic.taxiCabDistance((BlockPos)mutablePosInBox) > range || attacker.field_70170_p.func_180495_p(freezePos = victim.func_180425_c().func_177971_a((Vec3i)mutablePosInBox)).func_185904_a() != Material.field_151579_a) continue;
                        attacker.field_70170_p.func_175656_a(freezePos, BlockRegistry.tempIce.func_176223_P());
                        attacker.field_70170_p.func_175684_a(freezePos, (Block)BlockRegistry.tempIce, MathHelper.func_76136_a((Random)attacker.func_70681_au(), (int)60, (int)120));
                    }
                    attacker.field_70170_p.func_184148_a(null, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 0.8f, -1.0f);
                }
            }
        }
    }

    private static int taxiCabDistance(BlockPos pos) {
        return Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177956_o()) + Math.abs(pos.func_177952_p());
    }
}

