/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.damagemultiplier;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentDifficultysEndowment
extends EnchantmentBase {
    public EnchantmentDifficultysEndowment(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.difficultysEndowment;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.difficultysEndowment;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.difficultysEndowment, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.difficultysEndowment, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.difficultysEndowment, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.difficultysEndowment, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.difficultysEndowment;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            if (attacker.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                event.setAmount(event.getAmount() * 0.1f * (float)level);
            } else if (attacker.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                event.setAmount(event.getAmount() * (0.25f + 0.1f * (float)level));
            } else if (attacker.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                if (!attacker.field_70170_p.func_72912_H().func_76093_s()) {
                    event.setAmount(event.getAmount() * (1.0f + 0.1f * (float)level));
                } else {
                    event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)level));
                }
            }
        }
    }
}

