/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.damage;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class EnchantmentTierDamage
extends EnchantmentBase {
    private static final int LESSSHARP = 0;
    private static final int ADVSHARP = 1;
    private static final int SUPSHARP = 2;
    private static final int LESSSMITE = 3;
    private static final int ADVSMITE = 4;
    private static final int SUPSMITE = 5;
    private static final int LESSBOA = 6;
    private static final int ADVBOA = 7;
    private static final int SUPBOA = 8;
    private final int damageType;

    public EnchantmentTierDamage(String name, Enchantment.Rarity rarity, int damageTypeIn, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
        this.damageType = damageTypeIn;
    }

    @Override
    public boolean isEnabled() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.enabled.lesserSharpness;
            }
            case 1: {
                return ModConfig.enabled.advancedSharpness;
            }
            case 2: {
                return ModConfig.enabled.supremeSharpness;
            }
            case 3: {
                return ModConfig.enabled.lesserSmite;
            }
            case 4: {
                return ModConfig.enabled.advancedSmite;
            }
            case 5: {
                return ModConfig.enabled.supremeSmite;
            }
            case 6: {
                return ModConfig.enabled.lesserBaneOfArthropods;
            }
            case 7: {
                return ModConfig.enabled.advancedBaneOfArthropods;
            }
            case 8: {
                return ModConfig.enabled.supremeBaneOfArthropods;
            }
        }
        return false;
    }

    @Override
    public int func_77325_b() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.level.lesserSharpness;
            }
            case 1: {
                return ModConfig.level.advancedSharpness;
            }
            case 2: {
                return ModConfig.level.supremeSharpness;
            }
            case 3: {
                return ModConfig.level.lesserSmite;
            }
            case 4: {
                return ModConfig.level.advancedSmite;
            }
            case 5: {
                return ModConfig.level.supremeSmite;
            }
            case 6: {
                return ModConfig.level.lesserBaneOfArthropods;
            }
            case 7: {
                return ModConfig.level.advancedBaneOfArthropods;
            }
            case 8: {
                return ModConfig.level.supremeBaneOfArthropods;
            }
        }
        return 5;
    }

    @Override
    public int func_77321_a(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lesserSharpness, level);
            }
            case 1: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedSharpness, level);
            }
            case 2: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.supremeSharpness, level);
            }
            case 3: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lesserSmite, level);
            }
            case 4: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedSmite, level);
            }
            case 5: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.supremeSmite, level);
            }
            case 6: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lesserBaneOfArthropods, level);
            }
            case 7: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedBaneOfArthropods, level);
            }
            case 8: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.supremeBaneOfArthropods, level);
            }
        }
        return 0;
    }

    @Override
    public int func_77317_b(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lesserSharpness, level);
            }
            case 1: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedSharpness, level);
            }
            case 2: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.supremeSharpness, level);
            }
            case 3: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lesserSmite, level);
            }
            case 4: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedSmite, level);
            }
            case 5: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.supremeSmite, level);
            }
            case 6: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lesserBaneOfArthropods, level);
            }
            case 7: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedBaneOfArthropods, level);
            }
            case 8: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.supremeBaneOfArthropods, level);
            }
        }
        return 0;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.lesserSharpness, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedSharpness, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.supremeSharpness, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 3: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.lesserSmite, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 4: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedSmite, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 5: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.supremeSmite, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 6: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.lesserBaneOfArthropods, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 7: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedBaneOfArthropods, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 8: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.supremeBaneOfArthropods, stack) && super.canApplyAtEnchantingTable(stack);
            }
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lesserSharpness, stack) || super.func_92089_a(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedSharpness, stack) || super.func_92089_a(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.supremeSharpness, stack) || super.func_92089_a(stack);
            }
            case 3: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lesserSmite, stack) || super.func_92089_a(stack);
            }
            case 4: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedSmite, stack) || super.func_92089_a(stack);
            }
            case 5: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.supremeSmite, stack) || super.func_92089_a(stack);
            }
            case 6: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lesserBaneOfArthropods, stack) || super.func_92089_a(stack);
            }
            case 7: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedBaneOfArthropods, stack) || super.func_92089_a(stack);
            }
            case 8: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.supremeBaneOfArthropods, stack) || super.func_92089_a(stack);
            }
        }
        return false;
    }

    @Override
    public boolean func_185261_e() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.treasure.lesserSharpness;
            }
            case 1: {
                return ModConfig.treasure.advancedSharpness;
            }
            case 2: {
                return ModConfig.treasure.supremeSharpness;
            }
            case 3: {
                return ModConfig.treasure.lesserSmite;
            }
            case 4: {
                return ModConfig.treasure.advancedSmite;
            }
            case 5: {
                return ModConfig.treasure.supremeSmite;
            }
            case 6: {
                return ModConfig.treasure.lesserBaneOfArthropods;
            }
            case 7: {
                return ModConfig.treasure.advancedBaneOfArthropods;
            }
            case 8: {
                return ModConfig.treasure.supremeBaneOfArthropods;
            }
        }
        return false;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        switch (this.damageType) {
            case 0: {
                return 0.25f + 0.25f * (float)level;
            }
            case 1: {
                return 1.25f + 0.95f * (float)level;
            }
            case 2: {
                return 4.0f + 1.6f * (float)level;
            }
            case 3: {
                if (creatureType == EnumCreatureAttribute.UNDEAD) {
                    return 1.25f * (float)level;
                }
            }
            case 4: {
                if (creatureType == EnumCreatureAttribute.UNDEAD) {
                    return 3.25f * (float)level;
                }
            }
            case 5: {
                if (creatureType == EnumCreatureAttribute.UNDEAD) {
                    return 5.0f * (float)level;
                }
            }
            case 6: {
                if (creatureType == EnumCreatureAttribute.ARTHROPOD) {
                    return 1.25f * (float)level;
                }
            }
            case 7: {
                if (creatureType == EnumCreatureAttribute.ARTHROPOD) {
                    return 3.25f * (float)level;
                }
            }
            case 8: {
                if (creatureType != EnumCreatureAttribute.ARTHROPOD) break;
                return 5.0f * (float)level;
            }
        }
        return 0.0f;
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (weapon.func_190926_b()) {
            return;
        }
        if (!attacker.field_70170_p.field_72995_K) {
            if (this.damageType == 4 && victim.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                int duration = 60 + attacker.func_70681_au().nextInt(15 * level);
                victim.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 0));
            } else if (this.damageType == 5 && victim.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                int duration = 80 + attacker.func_70681_au().nextInt(20 * level);
                victim.func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, 1));
            } else if (this.damageType == 6 && victim.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                int duration = 10 + attacker.func_70681_au().nextInt(5 * level);
                victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 1));
            } else if (this.damageType == 7 && victim.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                int duration = 30 + attacker.func_70681_au().nextInt(15 * level);
                victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 4));
            } else if (this.damageType == 8 && victim.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                int duration = 40 + attacker.func_70681_au().nextInt(20 * level);
                victim.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 5));
            }
        }
    }
}

