/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.crits;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentLuckMagnification
extends EnchantmentBase {
    public EnchantmentLuckMagnification(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.luckMagnification;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.luckMagnification;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.luckMagnification, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.luckMagnification, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.luckMagnification, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.luckMagnification, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.luckMagnification;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCriticalHitEvent(CriticalHitEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isCriticalHitEventStrong(event)) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        if (!(attacker instanceof EntityPlayer)) {
            return;
        }
        if (!(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getCriticalHitEventStack(event, attacker);
        }
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            if (event.getResult() == Event.Result.DENY) {
                return;
            }
            IAttributeInstance luck = attacker.func_110148_a(SharedMonsterAttributes.field_188792_h);
            float amount = (float)luck.func_111126_e();
            if (amount <= 0.0f) {
                return;
            }
            if (event.getResult() != Event.Result.ALLOW && !event.isVanillaCritical() && attacker.func_70681_au().nextFloat() < Math.min(0.2f, 0.01f * amount * (float)level)) {
                event.setResult(Event.Result.ALLOW);
            }
            if ((event.getResult() == Event.Result.ALLOW || event.isVanillaCritical() && event.getResult() == Event.Result.DEFAULT) && attacker.func_70681_au().nextFloat() < Math.min(0.2f, 0.02f * amount * (float)level)) {
                event.setDamageModifier(event.getDamageModifier() + amount * 0.1f * (float)level);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLootingLevelEvent(LootingLevelEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getDamageSource())) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getDamageSource().func_76346_g();
        if (!(attacker instanceof EntityPlayer)) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)attacker);
        if (level > 0) {
            IAttributeInstance luck = attacker.func_110148_a(SharedMonsterAttributes.field_188792_h);
            event.setLootingLevel(event.getLootingLevel() + (int)(luck.func_111126_e() * (double)level / 2.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70173_aa % 9 != 0) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)player);
        if (level > 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 10, level - 1, true, false));
        }
    }
}

