/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.crits;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.SoundRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentCriticalStrike
extends EnchantmentBase {
    public EnchantmentCriticalStrike(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.criticalStrike;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.criticalStrike;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.criticalStrike, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.criticalStrike, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.criticalStrike, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.criticalStrike, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.criticalStrike;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCriticalHitEvent(CriticalHitEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isCriticalHitEventStrong(event)) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        if (attacker == null) {
            return;
        }
        if (!(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getCriticalHitEventStack(event, attacker);
        }
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            if (event.getResult() == Event.Result.DENY) {
                return;
            }
            if (event.getResult() == Event.Result.ALLOW || event.isVanillaCritical() && event.getResult() == Event.Result.DEFAULT) {
                NBTTagCompound compound = stack.func_77978_p();
                if (compound == null) {
                    compound = new NBTTagCompound();
                }
                int counter = 1 + compound.func_74762_e("CriticalStrikeFailCount");
                int maxChance = 1000 - 50 * level;
                int chance = 32 * counter;
                if (attacker.func_70681_au().nextInt(maxChance) >= chance) {
                    compound.func_74768_a("CriticalStrikeFailCount", counter);
                    attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundRegistry.CRITICAL_STRIKE_FAIL, SoundCategory.PLAYERS, 0.8f, 1.0f + 2.0f * (float)chance / (float)maxChance);
                    event.setDamageModifier(Math.max(1.5f, event.getDamageModifier()));
                } else {
                    compound.func_74768_a("CriticalStrikeFailCount", 0);
                    float crit = 1.0f + 0.5f * (float)level + 0.5f * (float)level * attacker.func_70681_au().nextFloat();
                    attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundRegistry.CRITICAL_STRIKE, SoundCategory.PLAYERS, 0.8f, 1.0f / (1.2f + 0.4f * attacker.func_70681_au().nextFloat()) * 1.6f);
                    event.setDamageModifier(event.getDamageModifier() + crit);
                }
                event.setResult(Event.Result.ALLOW);
                stack.func_77982_d(compound);
            }
        }
    }
}

