/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon.ancient;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.EnchantUtil;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class EnchantmentAncientSealedCurses
extends EnchantmentBase {
    public EnchantmentAncientSealedCurses(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.ancientSealedCurses;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.ancientSealedCurses;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.ancientSealedCurses, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.ancientSealedCurses, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.ancientSealedCurses, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.ancientSealedCurses, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.ancientSealedCurses;
    }

    @Override
    public boolean isAllowedOnBooks() {
        return false;
    }

    @Override
    public String getPrefix() {
        return TextFormatting.YELLOW.toString();
    }

    @Override
    public void onEntityDamagedAlt(EntityLivingBase attacker, Entity target, ItemStack weapon, int level) {
        if (!this.isEnabled()) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isOnEntityDamagedAltStrong()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)target;
        if (weapon.func_190926_b()) {
            return;
        }
        Iterable equipmentList = victim.func_184209_aF();
        List<Enchantment> curses = EnchantUtil.getCurses();
        if (curses.isEmpty()) {
            return;
        }
        for (ItemStack equipment : equipmentList) {
            if (equipment.func_190926_b() || !(attacker.func_70681_au().nextFloat() < 0.125f)) continue;
            Enchantment curse = curses.get(attacker.func_70681_au().nextInt(curses.size()));
            int curseLevel = 1 + attacker.func_70681_au().nextInt(curse.func_77325_b());
            if (!curse.func_92089_a(equipment)) continue;
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)equipment);
            boolean compatible = true;
            for (Enchantment enchant : enchants.keySet()) {
                if (curse != enchant && curse.func_191560_c(enchant)) continue;
                compatible = false;
                break;
            }
            if (!compatible) continue;
            equipment.func_77966_a(curse, curseLevel);
        }
    }
}

