/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.IEntityPlayerMixin;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentUnsheathing
extends EnchantmentBase {
    public EnchantmentUnsheathing(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.unsheathing;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.unsheathing;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.unsheathing, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.unsheathing, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.unsheathing, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.unsheathing, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.unsheathing;
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        ItemStack lastStack = ((IEntityPlayerMixin)player).soManyEnchantments$getLastHeldStack();
        ItemStack curStack = player.func_184614_ca();
        if (!curStack.func_190926_b() && curStack.func_77973_b() != lastStack.func_77973_b()) {
            ((IEntityPlayerMixin)player).soManyEnchantments$setLastSwapTime(player.field_70173_aa);
        }
        ((IEntityPlayerMixin)player).soManyEnchantments$setLastHeldStack(curStack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer attacker = (EntityPlayer)event.getSource().func_76346_g();
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            if (attacker.field_70170_p.field_72995_K) {
                return;
            }
            if (attacker.field_70173_aa - ((IEntityPlayerMixin)attacker).soManyEnchantments$getLastUnsheatheTrigger() < 100) {
                return;
            }
            if (attacker.field_70173_aa - ((IEntityPlayerMixin)attacker).soManyEnchantments$getLastSwapTime() < 10 + 10 * level) {
                ((IEntityPlayerMixin)attacker).soManyEnchantments$setLastUnsheatheTrigger(attacker.field_70173_aa);
                event.setAmount(event.getAmount() * (1.0f + 0.25f * (float)level));
            }
        }
    }
}

