/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentUnreasonable
extends EnchantmentBase {
    public EnchantmentUnreasonable(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.unreasonable;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.unreasonable;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.unreasonable, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.unreasonable, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.unreasonable, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.unreasonable, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.unreasonable;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving victim = (EntityLiving)event.getEntityLiving();
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level <= 0) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && attacker.func_70681_au().nextFloat() > RLCombatCompat.getAttackEntityFromStrength()) {
            return;
        }
        if (attacker.func_70681_au().nextFloat() < 0.05f * (float)level) {
            List entities = attacker.field_70170_p.func_175647_a(EntityLiving.class, victim.func_174813_aQ().func_186662_g((double)Math.min(3 + 3 * level, 16)), e -> e != attacker && e != victim);
            if (entities.isEmpty()) {
                return;
            }
            EntityLiving target = (EntityLiving)entities.get(attacker.func_70681_au().nextInt(entities.size()));
            if (attacker.field_70170_p instanceof WorldServer) {
                ((WorldServer)attacker.field_70170_p).func_152344_a(() -> {
                    try {
                        if (!(victim == null || target == null || victim.field_70128_L || target.field_70128_L || victim.func_110124_au().equals(target.func_110124_au()))) {
                            victim.func_70604_c((EntityLivingBase)target);
                            victim.func_70624_b((EntityLivingBase)target);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }
}

