/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentTierFA
extends EnchantmentBase {
    private static final Random RAND = new Random();
    private static final int LESSFIRE = 0;
    private static final int ADVFIRE = 1;
    private static final int SUPFIRE = 2;
    private final int damageType;

    public EnchantmentTierFA(String name, Enchantment.Rarity rarity, int damageTypeIn, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
        this.damageType = damageTypeIn;
    }

    public static int getLevelValue(EntityLivingBase entity) {
        if (entity == null) {
            return 0;
        }
        ItemStack stack = entity.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getFireAspectStack(entity);
        }
        int level = 0;
        if (EnchantmentRegistry.lesserFireAspect.isEnabled()) {
            level += EnchantmentTierFA.getLevelMult(EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.lesserFireAspect, (ItemStack)stack), 0);
        }
        if (EnchantmentRegistry.advancedFireAspect.isEnabled()) {
            level += EnchantmentTierFA.getLevelMult(EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedFireAspect, (ItemStack)stack), 1);
        }
        if (EnchantmentRegistry.supremeFireAspect.isEnabled()) {
            level += EnchantmentTierFA.getLevelMult(EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.supremeFireAspect, (ItemStack)stack), 2);
        }
        return level;
    }

    public static int getLevelMult(int level, int tier) {
        switch (tier) {
            case 0: {
                return RAND.nextInt(2) * level;
            }
            case 1: {
                return 2 * level;
            }
            case 2: {
                return 4 * level;
            }
        }
        return 0;
    }

    @Override
    public boolean isEnabled() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.enabled.lesserFireAspect;
            }
            case 1: {
                return ModConfig.enabled.advancedFireAspect;
            }
            case 2: {
                return ModConfig.enabled.supremeFireAspect;
            }
        }
        return false;
    }

    @Override
    public int func_77325_b() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.level.lesserFireAspect;
            }
            case 1: {
                return ModConfig.level.advancedFireAspect;
            }
            case 2: {
                return ModConfig.level.supremeFireAspect;
            }
        }
        return 2;
    }

    @Override
    public int func_77321_a(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lesserFireAspect, level);
            }
            case 1: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedFireAspect, level);
            }
            case 2: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.supremeFireAspect, level);
            }
        }
        return 0;
    }

    @Override
    public int func_77317_b(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lesserFireAspect, level);
            }
            case 1: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedFireAspect, level);
            }
            case 2: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.supremeFireAspect, level);
            }
        }
        return 0;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.lesserFireAspect, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedFireAspect, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.supremeFireAspect, stack) && super.canApplyAtEnchantingTable(stack);
            }
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lesserFireAspect, stack) || super.func_92089_a(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedFireAspect, stack) || super.func_92089_a(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.supremeFireAspect, stack) || super.func_92089_a(stack);
            }
        }
        return false;
    }

    @Override
    public boolean func_185261_e() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.treasure.lesserFireAspect;
            }
            case 1: {
                return ModConfig.treasure.advancedFireAspect;
            }
            case 2: {
                return ModConfig.treasure.supremeFireAspect;
            }
        }
        return false;
    }
}

