/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentPurgingBlade
extends EnchantmentBase {
    public EnchantmentPurgingBlade(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.purgingBlade;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.purgingBlade;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.purgingBlade, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.purgingBlade, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.purgingBlade, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.purgingBlade, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.purgingBlade;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level <= 0) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && attacker.func_70681_au().nextFloat() > RLCombatCompat.getAttackEntityFromStrength()) {
            return;
        }
        if (attacker.func_70681_au().nextFloat() < 0.1f + 0.06f * (float)level) {
            PotionEffect[] arr = victim.func_70651_bq().toArray(new PotionEffect[0]);
            if (arr.length == 0) {
                return;
            }
            PotionEffect effect = arr[attacker.func_70681_au().nextInt(arr.length)];
            event.setAmount(event.getAmount() * (1.0f + 0.02f * (float)(1 + effect.func_76458_c()) * (float)level));
            victim.func_184589_d(effect.func_188419_a());
        }
    }
}

