/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentParry
extends EnchantmentBase {
    public EnchantmentParry(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.parry;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.parry;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.parry, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.parry, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.parry, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.parry, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.parry;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource().func_76352_a()) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        if (!"player".equals(event.getSource().field_76373_n) && !"mob".equals(event.getSource().field_76373_n)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0) {
            if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.trueStrike, (ItemStack)attacker.func_184614_ca()) > 0) {
                return;
            }
            int levelCounter = EnchantmentHelper.func_185284_a((Enchantment)EnchantmentRegistry.counterAttack, (EntityLivingBase)victim);
            if (victim.func_70681_au().nextFloat() < 0.05f + 0.05f * (float)level + 0.01f * (float)levelCounter) {
                if (!victim.field_70170_p.field_72995_K) {
                    EnchantUtil.knockBackIgnoreKBRes((Entity)attacker, 0.3f + 0.15f * (float)level, victim.field_70165_t - attacker.field_70165_t, victim.field_70161_v - attacker.field_70161_v);
                }
                victim.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.3f, 3.0f);
                event.setCanceled(true);
                if ((float)victim.field_70172_ad <= (float)victim.field_70771_an / 2.0f) {
                    victim.field_70172_ad = victim.field_70771_an + 5 * (level - 1);
                }
            }
        }
    }
}

