/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentFieryEdge
extends EnchantmentBase {
    public EnchantmentFieryEdge(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getLevelValue(EntityLivingBase entity) {
        int level;
        if (!EnchantmentRegistry.fieryEdge.isEnabled()) {
            return 0;
        }
        if (entity == null) {
            return 0;
        }
        ItemStack stack = entity.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getFireAspectStack(entity);
        }
        if ((level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.fieryEdge, (ItemStack)stack)) <= 0) {
            return 0;
        }
        return EnchantmentFieryEdge.getLevelMult(level);
    }

    public static int getLevelMult(int level) {
        return 2 * level;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.fieryEdge;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.fieryEdge;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.fieryEdge, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.fieryEdge, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.fieryEdge, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.fieryEdge, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.fieryEdge;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level <= 0) {
            return;
        }
        if (victim.func_70027_ad() && (float)victim.field_70172_ad > (float)victim.field_70771_an / 2.0f && attacker.func_70681_au().nextFloat() < 0.05f * (float)level) {
            victim.field_70172_ad = 0;
        }
    }
}

