/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.mixin.vanilla.IEntityLivingMixin;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentDisarmament
extends EnchantmentBase {
    public EnchantmentDisarmament(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.disarmament;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.disarmament;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.disarmament, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.disarmament, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.disarmament, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.disarmament, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.disarmament;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isAttackEntityFromStrong()) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0 && attacker.func_70681_au().nextFloat() < 0.02f * (float)level) {
            if (!victim.func_184614_ca().func_190926_b()) {
                if (victim instanceof EntityLiving && attacker.func_70681_au().nextFloat() >= ((IEntityLivingMixin)victim).getInventoryHandsDropChances()[0]) {
                    return;
                }
                victim.func_70099_a(victim.func_184614_ca(), 0.5f);
                victim.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            } else if (!victim.func_184592_cb().func_190926_b()) {
                if (victim instanceof EntityLiving && attacker.func_70681_au().nextFloat() >= ((IEntityLivingMixin)victim).getInventoryHandsDropChances()[1]) {
                    return;
                }
                victim.func_70099_a(victim.func_184592_cb(), 0.5f);
                victim.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            }
        }
    }
}

