/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.SoundRegistry;
import com.shultrea.rin.util.IEntityDamageSourceMixin;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentCulling
extends EnchantmentBase {
    public EnchantmentCulling(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.culling;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.culling;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.culling, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.culling, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.culling, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.culling, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.culling;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded() && !RLCombatCompat.isAttackEntityFromStrong()) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0 && !attacker.field_70170_p.field_72995_K) {
            float curHealth = victim.func_110143_aJ();
            if (curHealth - event.getAmount() <= 0.0f) {
                return;
            }
            if ((curHealth - event.getAmount()) / victim.func_110138_aP() <= 0.075f + 0.025f * (float)level) {
                for (int i = 0; i < 8; ++i) {
                    attacker.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_ANGRY, victim.field_70165_t, victim.field_70163_u + 1.0, victim.field_70161_v, victim.func_70681_au().nextGaussian() * 0.02, victim.func_70681_au().nextGaussian() * 0.02, victim.func_70681_au().nextGaussian() * 0.02, new int[0]);
                }
                if (attacker.func_70681_au().nextFloat() < 0.001f) {
                    attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundRegistry.CULLING, SoundCategory.PLAYERS, 2.0f, 1.0f);
                }
                event.setAmount(Math.max(event.getAmount(), victim.func_110138_aP()) * 10.0f);
                if (event.getSource() instanceof EntityDamageSource) {
                    ((IEntityDamageSourceMixin)event.getSource()).soManyEnchantments$setCulling();
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        if (!((IEntityDamageSourceMixin)event.getSource()).soManyEnchantments$getCulling()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_70681_au().nextFloat() <= 0.25f) {
            NBTTagCompound compound;
            ItemStack skull;
            if (entity instanceof EntitySkeleton) {
                skull = new ItemStack(Items.field_151144_bL, 1, 0);
            } else if (entity instanceof EntityWitherSkeleton) {
                skull = new ItemStack(Items.field_151144_bL, 1, 1);
            } else if (entity instanceof EntityZombie && !(entity instanceof EntityPigZombie)) {
                skull = new ItemStack(Items.field_151144_bL, 1, 2);
            } else if (entity instanceof EntityCreeper) {
                skull = new ItemStack(Items.field_151144_bL, 1, 4);
            } else if (entity instanceof EntityPlayer) {
                skull = new ItemStack(Items.field_151144_bL, 1, 3);
                compound = new NBTTagCompound();
                compound.func_74778_a("SkullOwner", entity.func_70005_c_());
                skull.func_77982_d(compound);
            } else {
                skull = new ItemStack(Items.field_151144_bL, 1, 3);
                compound = new NBTTagCompound();
                if (entity instanceof EntityBlaze) {
                    compound.func_74778_a("SkullOwner", "MHF_Blaze");
                } else if (entity instanceof EntityPigZombie) {
                    compound.func_74778_a("SkullOwner", "MHF_PigZombie");
                } else if (entity instanceof EntityCaveSpider) {
                    compound.func_74778_a("SkullOwner", "MHF_CaveSpider");
                } else if (entity instanceof EntitySpider) {
                    compound.func_74778_a("SkullOwner", "MHF_Spider");
                } else if (entity instanceof EntityChicken) {
                    compound.func_74778_a("SkullOwner", "MHF_Chicken");
                } else if (entity instanceof EntityMooshroom) {
                    compound.func_74778_a("SkullOwner", "MHF_MushroomCow");
                } else if (entity instanceof EntityCow) {
                    compound.func_74778_a("SkullOwner", "MHF_Cow");
                } else if (entity instanceof EntityEnderman) {
                    compound.func_74778_a("SkullOwner", "MHF_Enderman");
                } else if (entity instanceof EntityGhast) {
                    compound.func_74778_a("SkullOwner", "MHF_Ghast");
                } else if (entity instanceof EntityIronGolem) {
                    compound.func_74778_a("SkullOwner", "MHF_Golem");
                } else if (entity instanceof EntityMagmaCube) {
                    compound.func_74778_a("SkullOwner", "MHF_LavaSlime");
                } else if (entity instanceof EntityOcelot) {
                    compound.func_74778_a("SkullOwner", "MHF_Ocelot");
                } else if (entity instanceof EntityPig) {
                    compound.func_74778_a("SkullOwner", "MHF_Pig");
                } else if (entity instanceof EntitySheep) {
                    compound.func_74778_a("SkullOwner", "MHF_Sheep");
                } else if (entity instanceof EntitySlime) {
                    compound.func_74778_a("SkullOwner", "MHF_Slime");
                } else if (entity instanceof EntitySquid) {
                    compound.func_74778_a("SkullOwner", "MHF_Squid");
                } else if (entity instanceof EntityVillager) {
                    compound.func_74778_a("SkullOwner", "MHF_Villager");
                } else {
                    return;
                }
                skull.func_77982_d(compound);
            }
            EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skull);
            event.getDrops().add(entityItem);
        }
    }
}

