/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentCounterAttack
extends EnchantmentBase {
    public EnchantmentCounterAttack(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.counterAttack;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.counterAttack;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.counterAttack, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.counterAttack, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.counterAttack, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.counterAttack, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.counterAttack;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource().func_76352_a()) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        if (!"player".equals(event.getSource().field_76373_n) && !"mob".equals(event.getSource().field_76373_n)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0) {
            int levelParry = EnchantmentHelper.func_185284_a((Enchantment)EnchantmentRegistry.parry, (EntityLivingBase)victim);
            if (victim.func_70681_au().nextFloat() < 0.05f + 0.05f * (float)level + 0.01f * (float)levelParry) {
                attacker.func_70097_a((DamageSource)new EntityDamageSource("thorns", (Entity)victim).func_180138_v(), event.getAmount() * 0.2f * (float)level);
            }
        }
    }
}

