/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.weapon.EnchantmentFieryEdge;
import com.shultrea.rin.enchantments.weapon.EnchantmentTierFA;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.EnchantUtil;
import com.shultrea.rin.util.compat.CompatUtil;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentArcSlash
extends EnchantmentBase {
    private boolean handlingArcSlash = false;

    public EnchantmentArcSlash(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.arcSlash;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.arcSlash;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.arcSlash, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.arcSlash, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.arcSlash, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.arcSlash, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.arcSlash;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (CompatUtil.isRLCombatLoaded()) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (this.handlingArcSlash) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            int lvl;
            this.handlingArcSlash = true;
            int fireLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
            if (EnchantmentRegistry.fieryEdge.isEnabled() && (lvl = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.fieryEdge, (ItemStack)stack)) > 0) {
                fireLevel += EnchantmentFieryEdge.getLevelMult(lvl);
            }
            if (EnchantmentRegistry.lesserFireAspect.isEnabled() && (lvl = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.lesserFireAspect, (ItemStack)stack)) > 0) {
                fireLevel += EnchantmentTierFA.getLevelMult(lvl, 0);
            }
            if (EnchantmentRegistry.advancedFireAspect.isEnabled() && (lvl = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedFireAspect, (ItemStack)stack)) > 0) {
                fireLevel += EnchantmentTierFA.getLevelMult(lvl, 1);
            }
            if (EnchantmentRegistry.supremeFireAspect.isEnabled() && (lvl = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.supremeFireAspect, (ItemStack)stack)) > 0) {
                fireLevel += EnchantmentTierFA.getLevelMult(lvl, 2);
            }
            fireLevel /= 2;
            int levitationLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.levitator, (ItemStack)stack);
            float damage = event.getAmount() * 0.25f * (float)level;
            AxisAlignedBB boundBox = new AxisAlignedBB(attacker.field_70165_t - 5.0 - (double)level, attacker.field_70163_u - 5.0 - (double)level, attacker.field_70161_v - 5.0 - (double)level, attacker.field_70165_t + 5.0 + (double)level, attacker.field_70163_u + 5.0 + (double)level, attacker.field_70161_v + 5.0 + (double)level);
            ArrayList targetEntities = new ArrayList(attacker.func_130014_f_().func_72839_b(event.getEntity(), boundBox));
            for (Entity target : targetEntities) {
                Vec3d attackerCheck;
                double angle;
                if (!(target instanceof EntityLivingBase) || target == attacker || target == victim || target.func_70032_d((Entity)attacker) > 3.0f + 0.25f * (float)level || !((angle = Math.toDegrees(Math.acos((attackerCheck = new Vec3d(target.field_70165_t - attacker.field_70165_t, target.field_70163_u - attacker.field_70163_u, target.field_70161_v - attacker.field_70161_v)).func_72432_b().func_72430_b(attacker.func_70040_Z())))) < MathHelper.func_151237_a((double)(60.0 + (double)(level * 10)), (double)60.0, (double)359.0))) continue;
                EntityDamageSource source = null;
                if (attacker instanceof EntityPlayer) {
                    source = new EntityDamageSource("playerCleave", (Entity)attacker);
                    target.func_70097_a((DamageSource)source, damage);
                    target.func_70015_d(fireLevel * 4);
                    if (levitationLevel > 0 && !attacker.field_70170_p.field_72995_K) {
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 30 + levitationLevel * 12, 1 + levitationLevel));
                    }
                }
                if (attacker instanceof EntityMob) {
                    source = new EntityDamageSource("mobCleave", (Entity)attacker);
                    target.func_70097_a((DamageSource)source, damage);
                    target.func_70015_d(fireLevel * 4);
                    if (levitationLevel > 0 && !attacker.field_70170_p.field_72995_K) {
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 30 + levitationLevel * 12, 1 + levitationLevel));
                    }
                }
                if (source == null) {
                    target.func_70097_a(DamageSource.field_76377_j, damage);
                }
                int levelKnockback = 1;
                levelKnockback += EnchantmentHelper.func_77501_a((EntityLivingBase)attacker);
                if (attacker.func_70051_ag()) {
                    ++levelKnockback;
                }
                if ((levelKnockback /= 2) <= 0) continue;
                EnchantUtil.knockBackIgnoreKBRes(target, 0.3f * (float)levelKnockback, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
            }
            attacker.func_70031_b(false);
            this.handlingArcSlash = false;
        }
    }
}

