/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentAdvancedLooting
extends EnchantmentBase {
    public EnchantmentAdvancedLooting(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getLevelValue(EntityLivingBase entity) {
        if (!EnchantmentRegistry.advancedLooting.isEnabled()) {
            return 0;
        }
        if (entity == null) {
            return 0;
        }
        ItemStack stack = entity.func_184614_ca();
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedLooting, (ItemStack)stack);
        if (level <= 0) {
            return 0;
        }
        return EnchantmentAdvancedLooting.getLevelMult(level);
    }

    public static int getLevelMult(int level) {
        int toReturn = 2 + 2 * level;
        if (Math.random() < 0.25) {
            toReturn = 3 + 3 * level;
        }
        return toReturn;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedLooting;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedLooting;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedLooting, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedLooting, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedLooting, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedLooting, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedLooting;
    }
}

