/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.weapon;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class EnchantmentAdvancedKnockback
extends EnchantmentBase {
    public EnchantmentAdvancedKnockback(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getLevelValue(EntityLivingBase entity) {
        int level;
        if (!EnchantmentRegistry.advancedKnockback.isEnabled()) {
            return 0;
        }
        if (entity == null) {
            return 0;
        }
        ItemStack stack = entity.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getKnockbackStack(entity);
        }
        if ((level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedKnockback, (ItemStack)stack)) <= 0) {
            return 0;
        }
        return EnchantmentAdvancedKnockback.getLevelMult(level);
    }

    public static int getLevelMult(int level) {
        return MathHelper.func_76141_d((float)((float)level * 2.5f));
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedKnockback;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedKnockback;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedKnockback, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedKnockback, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedKnockback, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedKnockback, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedKnockback;
    }
}

