/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.tool;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSmelter
extends EnchantmentBase {
    public EnchantmentSmelter(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.smelter;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.smelter;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.smelter, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.smelter, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.smelter, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.smelter, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.smelter;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null) {
            return;
        }
        ItemStack tool = player.func_184614_ca();
        if (tool.func_190926_b()) {
            return;
        }
        if (event.isSilkTouching()) {
            return;
        }
        if (player.func_70093_af()) {
            return;
        }
        if (event.getDrops().isEmpty()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)tool);
        if (level > 0 && (tool.func_150998_b(event.getState()) || ForgeHooks.isToolEffective((IBlockAccess)player.field_70170_p, (BlockPos)event.getPos(), (ItemStack)tool))) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (ItemStack origDrop : event.getDrops()) {
                int toDrop;
                if (origDrop.func_190926_b()) continue;
                int origAmount = origDrop.func_190916_E();
                ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(origDrop.func_77973_b(), 1, origDrop.func_77960_j()));
                if (smeltResult.func_190926_b()) {
                    if (!(event.getWorld().field_73012_v.nextFloat() <= event.getDropChance())) continue;
                    drops.add(origDrop);
                    continue;
                }
                int levelFortune = event.getFortuneLevel();
                if (levelFortune > 0 && !(smeltResult.func_77973_b() instanceof ItemBlock)) {
                    origAmount *= 1 + player.func_70681_au().nextInt(levelFortune + 1);
                }
                for (int dropAmount = origAmount * smeltResult.func_190916_E(); dropAmount > 0; dropAmount -= toDrop) {
                    toDrop = Math.min(dropAmount, smeltResult.func_77976_d());
                    ItemStack dropStack = new ItemStack(smeltResult.func_77973_b(), toDrop, smeltResult.func_77960_j());
                    if (!(event.getWorld().field_73012_v.nextFloat() <= event.getDropChance())) continue;
                    event.getWorld().func_175688_a(EnumParticleTypes.FLAME, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
                    drops.add(dropStack);
                }
            }
            for (ItemStack drop : drops) {
                Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)drop);
            }
            event.setDropChance(0.0f);
            event.getDrops().clear();
        }
    }
}

