/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.shield;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentNaturalBlocking
extends EnchantmentBase {
    public EnchantmentNaturalBlocking(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.naturalBlocking;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.naturalBlocking;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.naturalBlocking, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.naturalBlocking, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.naturalBlocking, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.naturalBlocking, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.naturalBlocking;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.func_184585_cz() || event.getSource().func_76363_c()) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0) {
            ItemStack shield = victim.func_184614_ca();
            if (!(!shield.func_190926_b() && shield.func_77973_b().isShield(shield, victim) || !(shield = victim.func_184592_cb()).func_190926_b() && shield.func_77973_b().isShield(shield, victim))) {
                return;
            }
            float blockedDamage = event.getAmount() * (0.1f * (float)level);
            event.setAmount(event.getAmount() - blockedDamage);
            shield.func_77972_a((int)(1.0f + 1.5f * blockedDamage), victim);
        }
    }
}

