/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.shield;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentBurningShield
extends EnchantmentBase {
    public EnchantmentBurningShield(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.burningShield;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.burningShield;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.burningShield, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.burningShield, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.burningShield, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.burningShield, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.burningShield;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource().func_76352_a()) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        if (!"player".equals(event.getSource().field_76373_n) && !"mob".equals(event.getSource().field_76373_n)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
        if (!EnchantUtil.canBlockDamageSource(event.getSource(), victim)) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0 && victim.func_70681_au().nextFloat() < 0.4f + 0.1f * (float)level) {
            float revengeDamage = event.getAmount() * 0.1f * (float)level;
            attacker.func_70097_a(new EntityDamageSource("onFire", (Entity)victim).func_76361_j(), revengeDamage);
            attacker.func_70015_d(4 + 2 * level);
        }
    }
}

