/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.fishing;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentAdvancedLure
extends EnchantmentBase {
    public EnchantmentAdvancedLure(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getLevelValue(ItemStack stack) {
        if (!EnchantmentRegistry.advancedLure.isEnabled()) {
            return 0;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedLure, (ItemStack)stack);
        if (level <= 0) {
            return 0;
        }
        return EnchantmentAdvancedLure.getLevelMult(level);
    }

    public static int getLevelMult(int level) {
        int toReturn = 1 + level;
        if (Math.random() < 0.25) {
            toReturn = 2 + level;
        }
        return toReturn;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedLure;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedLure;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedLure, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedLure, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedLure, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedLure, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedLure;
    }
}

