/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.fishing;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentAdvancedLuckOfTheSea
extends EnchantmentBase {
    public EnchantmentAdvancedLuckOfTheSea(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getLevelValue(ItemStack stack) {
        if (!EnchantmentRegistry.advancedLuckOfTheSea.isEnabled()) {
            return 0;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.advancedLuckOfTheSea, (ItemStack)stack);
        if (level <= 0) {
            return 0;
        }
        return EnchantmentAdvancedLuckOfTheSea.getLevelMult(level);
    }

    public static int getLevelMult(int level) {
        int toReturn = 2 + 2 * level;
        if (Math.random() < 0.25) {
            toReturn = 3 + 3 * level;
        }
        return toReturn;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedLuckOfTheSea;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedLuckOfTheSea;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedLuckOfTheSea, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedLuckOfTheSea, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedLuckOfTheSea, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedLuckOfTheSea, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedLuckOfTheSea;
    }
}

