/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentUnpredictable
extends EnchantmentCurse {
    public EnchantmentUnpredictable(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.unpredictable;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.unpredictable;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.unpredictable, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.unpredictable, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.unpredictable, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.unpredictable, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.unpredictable;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0) {
            float damage = attacker.func_70681_au().nextFloat() * ((float)level + 1.0f) * event.getAmount();
            event.setAmount(damage);
            if (attacker.func_70681_au().nextFloat() < (float)level * 0.2f) {
                event.setCanceled(true);
                if (event.getEntityLiving() != null) {
                    event.getEntityLiving().func_70691_i(damage);
                }
            }
        }
    }
}

