/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.SoManyEnchantments;
import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import com.shultrea.rin.registry.SoundRegistry;
import com.shultrea.rin.util.EnchantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentPandorasCurse
extends EnchantmentCurse {
    public EnchantmentPandorasCurse(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.pandorasCurse;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.pandorasCurse;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.pandorasCurse, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.pandorasCurse, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.pandorasCurse, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.pandorasCurse, stack) || super.func_92089_a(stack);
    }

    @Override
    public String func_77316_c(int level) {
        if (!this.isEnabled()) {
            return super.func_77316_c(level);
        }
        String s = I18n.func_74838_a((String)this.func_77320_a());
        s = TextFormatting.DARK_RED + s;
        EntityPlayer player = SoManyEnchantments.PROXY.getClientPlayer();
        return level < 3 && player != null && !player.func_184812_l_() ? "" : s;
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.pandorasCurse;
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.player.field_70173_aa % ModConfig.miscellaneous.pandorasCurseInterval == 0) {
            int lvl;
            InventoryPlayer inv = event.player.field_71071_by;
            ItemStack cursedStack = ItemStack.field_190927_a;
            int curseLevel = 0;
            ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
            for (ItemStack stack : inv.field_184439_c) {
                if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemEnchantedBook) continue;
                lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
                if (lvl > 0) {
                    cursedStack = stack;
                    curseLevel = lvl;
                    continue;
                }
                if (stack.func_77976_d() != 1) continue;
                candidates.add(stack);
            }
            for (ItemStack stack : inv.field_70460_b) {
                if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemEnchantedBook) continue;
                lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
                if (lvl > 0) {
                    cursedStack = stack;
                    curseLevel = lvl;
                    continue;
                }
                if (stack.func_77976_d() != 1) continue;
                candidates.add(stack);
            }
            for (ItemStack stack : inv.field_70462_a) {
                if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemEnchantedBook) continue;
                lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
                if (lvl > 0) {
                    cursedStack = stack;
                    curseLevel = lvl;
                    continue;
                }
                if (stack.func_77976_d() != 1) continue;
                candidates.add(stack);
            }
            if (cursedStack.func_190926_b() || candidates.isEmpty()) {
                return;
            }
            int origCurseLevel = curseLevel;
            List<Enchantment> curses = EnchantUtil.getCurses();
            for (ItemStack stack : candidates) {
                Enchantment curse;
                if (curseLevel > 5 || event.player.field_70170_p.field_73012_v.nextInt(8) >= 1 || (curse = curses.get(event.player.field_70170_p.field_73012_v.nextInt(curses.size()))) == this || !curse.func_92089_a(stack)) continue;
                boolean compat = true;
                for (Enchantment ench : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
                    if (ench.func_191560_c(curse)) continue;
                    compat = false;
                    break;
                }
                if (!compat) continue;
                ++curseLevel;
                stack.func_77966_a(curse, event.player.field_70170_p.field_73012_v.nextInt(curse.func_77325_b()) + 1);
            }
            if (curseLevel != origCurseLevel || curseLevel > 5) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)cursedStack);
                if (curseLevel > 5) {
                    enchants.remove((Object)this);
                    event.player.field_70170_p.func_184148_a(null, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, SoundRegistry.PANDORA_REMOVAL, SoundCategory.PLAYERS, 0.8f, (event.player.field_70170_p.field_73012_v.nextFloat() - event.player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.4f);
                } else {
                    enchants.put(this, curseLevel);
                }
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)cursedStack);
            }
        }
    }
}

