/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentInstability
extends EnchantmentCurse {
    public EnchantmentInstability(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.instability;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.instability;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.instability, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.instability, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.instability, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.instability, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.instability;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        if (event.getAmount() <= 1.0f) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)stack);
        if (level > 0 && stack.func_77984_f()) {
            float percentage = (float)stack.func_77952_i() / (float)stack.func_77958_k();
            percentage = 1.0f + percentage * 0.75f * (float)level;
            event.setAmount(event.getAmount() * percentage);
            stack.func_77972_a(1 + (int)(attacker.func_70681_au().nextFloat() * event.getAmount() / (float)(8 - level)), attacker);
        }
    }
}

