/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentHeavyWeight
extends EnchantmentCurse {
    public EnchantmentHeavyWeight(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.heavyWeight;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.heavyWeight;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.heavyWeight, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.heavyWeight, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.heavyWeight, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.heavyWeight, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.heavyWeight;
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)event.getEntityLiving());
        if (enchantmentLevel > 0) {
            event.getEntityLiving().field_70181_x *= 1.0 - (double)enchantmentLevel * 0.1;
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)event.getEntityLiving());
        if (enchantmentLevel > 0) {
            event.setDamageMultiplier(event.getDamageMultiplier() * (1.0f + (float)enchantmentLevel * 0.25f));
        }
    }
}

