/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentDragging
extends EnchantmentCurse {
    public EnchantmentDragging(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.dragging;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.dragging;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.dragging, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.dragging, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.dragging, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.dragging, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.dragging;
    }

    public static int getLevelValue(EntityLivingBase entity) {
        if (!EnchantmentRegistry.dragging.isEnabled()) {
            return 0;
        }
        if (entity == null) {
            return 0;
        }
        ItemStack stack = entity.func_184614_ca();
        if (CompatUtil.isRLCombatLoaded()) {
            stack = RLCombatCompat.getKnockbackStack(entity);
        }
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.dragging, (ItemStack)stack);
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        if (!EnchantmentRegistry.dragging.isEnabled()) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        EntityLivingBase victim = event.getEntityLiving();
        int draggingLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.dragging, (ItemStack)attacker.func_184614_ca());
        if (draggingLevel <= 0) {
            return;
        }
        double velocityMultiplier = -0.6f * (1.25f + (float)draggingLevel * 1.75f);
        float piDiv180 = (float)Math.PI / 180;
        victim.func_70024_g((double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * piDiv180))) * velocityMultiplier, 0.1, (double)MathHelper.func_76134_b((float)(attacker.field_70177_z * piDiv180)) * velocityMultiplier);
        victim.field_70133_I = true;
    }
}

