/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import com.shultrea.rin.registry.EnchantmentRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentCurseofPossession
extends EnchantmentCurse {
    public EnchantmentCurseofPossession(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.curseOfPossession;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.curseOfPossession;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.curseOfPossession, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.curseOfPossession, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.curseOfPossession, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.curseOfPossession, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.curseOfPossession;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTossEvent(ItemTossEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.func_184812_l_()) {
            return;
        }
        ItemStack origStack = event.getEntityItem().func_92059_d();
        if (origStack.func_190926_b()) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)origStack);
        if (level > 0) {
            EntityItem entityItem;
            ItemStack copyStack = origStack.func_77946_l();
            boolean flag = player.field_71071_by.func_70441_a(copyStack);
            if (!flag && !player.field_70170_p.field_72995_K && (entityItem = player.func_70099_a(copyStack, -0.3f + player.func_70047_e())) != null) {
                entityItem.func_145797_a(player.func_70005_c_());
                entityItem.func_174868_q();
                entityItem.func_184224_h(true);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        EntityPlayer player;
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityItem)) {
            return;
        }
        EntityItem item = (EntityItem)event.getEntity();
        if (item.func_92059_d().func_190926_b()) {
            return;
        }
        ItemStack copyStack = item.func_92059_d().func_77946_l();
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.curseOfPossession, (ItemStack)copyStack);
        if (level > 0 && (player = event.getWorld().func_72890_a((Entity)item, 8.0)) != null && !player.func_184812_l_()) {
            if (player.func_70089_S() && player.func_191521_c(copyStack)) {
                event.setCanceled(true);
                return;
            }
            item.lifespan = ModConfig.miscellaneous.curseOfPossessionDeathDeletion ? 5 : 200;
            item.func_174867_a(10);
        }
    }
}

