/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentCurseofHolding
extends EnchantmentCurse {
    public EnchantmentCurseofHolding(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.curseOfHolding;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.curseOfHolding;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.curseOfHolding, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.curseOfHolding, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.curseOfHolding, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.curseOfHolding, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.curseOfHolding;
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        int level;
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70173_aa % 9 == 0 && (level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)player)) > 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, level - 1, false, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 10, level > 1 ? 1 : 0, false, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 10, level - 1, false, false));
            if (level > 1) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 10, level - 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 10, level - 1, false, false));
            }
        }
    }
}

