/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentBreachedPlating
extends EnchantmentCurse {
    private static final UUID BREACHEDPLATING_UUID = UUID.fromString("8e07ebc9-f6f6-439c-8e65-00a70cd0b226");

    public EnchantmentBreachedPlating(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.breachedPlating;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.breachedPlating;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.breachedPlating, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.breachedPlating, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.breachedPlating, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.breachedPlating, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.breachedPlating;
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving().field_70173_aa % 20 != 0) {
            return;
        }
        EntityLivingBase user = event.getEntityLiving();
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)user);
        IAttributeInstance armor = user.func_110148_a(SharedMonsterAttributes.field_188791_g);
        if (level > 0) {
            EnchantmentBreachedPlating.addArmorDebuffModifier(level, armor);
        } else {
            armor.func_188479_b(BREACHEDPLATING_UUID);
        }
    }

    private static void addArmorDebuffModifier(int level, IAttributeInstance instance) {
        double amount = -0.1 * (double)level;
        AttributeModifier modifier = new AttributeModifier(BREACHEDPLATING_UUID, "BreachedPlatingDebuff", amount, 2);
        AttributeModifier previous = instance.func_111127_a(BREACHEDPLATING_UUID);
        if (previous == null) {
            instance.func_111121_a(modifier);
        } else if (previous.func_111164_d() != amount) {
            instance.func_188479_b(BREACHEDPLATING_UUID);
            instance.func_111121_a(modifier);
        }
    }
}

