/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.curses;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.enchantments.base.EnchantmentCurse;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentAscetic
extends EnchantmentCurse {
    public EnchantmentAscetic(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.ascetic;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.ascetic;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.ascetic, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.ascetic, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.ascetic, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.ascetic, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.ascetic;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLootingLevelEvent(LootingLevelEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getDamageSource())) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getDamageSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)attacker);
        if (level > 0) {
            if (attacker.field_70170_p.field_72995_K) {
                return;
            }
            event.setLootingLevel(Math.max(0, event.getLootingLevel() - level));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed(event.getSource())) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim instanceof EntityPlayer) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)attacker);
        if (level > 0) {
            if (attacker.field_70170_p.field_72995_K) {
                return;
            }
            if (!victim.func_184222_aU()) {
                return;
            }
            if (attacker.func_70681_au().nextFloat() < 0.25f * (float)level) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemFished(ItemFishedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase user = event.getEntityLiving();
        if (user == null) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)user);
        if (level > 0) {
            if (user.field_70170_p.field_72995_K) {
                return;
            }
            if (user.func_70681_au().nextFloat() < 0.25f * (float)level) {
                event.setCanceled(true);
            }
        }
    }
}

