/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.bow;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentTierFlame
extends EnchantmentBase {
    private final int damageType;

    public EnchantmentTierFlame(String name, Enchantment.Rarity rarity, int damageTypeIn, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
        this.damageType = damageTypeIn;
    }

    @Override
    public boolean isEnabled() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.enabled.lesserFlame;
            }
            case 1: {
                return ModConfig.enabled.advancedFlame;
            }
            case 2: {
                return ModConfig.enabled.supremeFlame;
            }
        }
        return false;
    }

    @Override
    public int func_77325_b() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.level.lesserFlame;
            }
            case 1: {
                return ModConfig.level.advancedFlame;
            }
            case 2: {
                return ModConfig.level.supremeFlame;
            }
        }
        return 1;
    }

    @Override
    public int func_77321_a(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lesserFlame, level);
            }
            case 1: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedFlame, level);
            }
            case 2: {
                return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.supremeFlame, level);
            }
        }
        return 0;
    }

    @Override
    public int func_77317_b(int level) {
        switch (this.damageType) {
            case 0: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lesserFlame, level);
            }
            case 1: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedFlame, level);
            }
            case 2: {
                return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.supremeFlame, level);
            }
        }
        return 0;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.lesserFlame, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedFlame, stack) && super.canApplyAtEnchantingTable(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApply.supremeFlame, stack) && super.canApplyAtEnchantingTable(stack);
            }
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        switch (this.damageType) {
            case 0: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lesserFlame, stack) || super.func_92089_a(stack);
            }
            case 1: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedFlame, stack) || super.func_92089_a(stack);
            }
            case 2: {
                return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.supremeFlame, stack) || super.func_92089_a(stack);
            }
        }
        return false;
    }

    @Override
    public boolean func_185261_e() {
        switch (this.damageType) {
            case 0: {
                return ModConfig.treasure.lesserFlame;
            }
            case 1: {
                return ModConfig.treasure.advancedFlame;
            }
            case 2: {
                return ModConfig.treasure.supremeFlame;
            }
        }
        return false;
    }
}

