/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.bow;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.mixin.vanilla.IItemBowMixin;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.IceAndFireCompat;
import com.shultrea.rin.util.compat.SwitchbowCompat;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSplitshot
extends EnchantmentBase {
    public EnchantmentSplitshot(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.splitShot;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.splitShot;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.splitShot, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.splitShot, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.splitShot, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.splitShot, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.splitShot;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowLooseEvent(ArrowLooseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack bow = event.getBow();
        if (!(bow.func_77973_b() instanceof ItemBow)) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)bow);
        if (level > 0) {
            for (int x = 0; x < level; ++x) {
                int k;
                int j;
                float f;
                boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
                ItemStack ammo = CompatUtil.isSwitchbowLoaded() && SwitchbowCompat.isSwitchbow(bow) ? SwitchbowCompat.getSwitchbowAmmo(player, bow) : ((IItemBowMixin)bow.func_77973_b()).invokeFindAmmo(player);
                if (ammo.func_190926_b() && !flag) continue;
                if (ammo.func_190926_b()) {
                    ammo = CompatUtil.isIceAndFireLoaded() && IceAndFireCompat.isDragonboneBow(bow) ? new ItemStack(IceAndFireCompat.getDragonboneArrow()) : new ItemStack(Items.field_151032_g);
                }
                if (!((double)(f = ItemBow.func_185059_b((int)event.getCharge())) >= 0.1)) continue;
                ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(player.field_70170_p, ammo, (EntityLivingBase)player);
                entityarrow = ((ItemBow)bow.func_77973_b()).customizeArrow(entityarrow);
                entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 3.0f + player.func_70681_au().nextFloat() * 6.0f);
                if (f == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bow)) > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                    entityarrow.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bow) > 0) {
                    entityarrow.func_70015_d(100);
                }
                bow.func_77972_a(1, (EntityLivingBase)player);
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                player.field_70170_p.func_72838_d((Entity)entityarrow);
            }
        }
    }
}

