/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.bow;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentPushing
extends EnchantmentBase {
    public EnchantmentPushing(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.pushing;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.pushing;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.pushing, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.pushing, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.pushing, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.pushing, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.pushing;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingEntityUseItem(LivingEntityUseItemEvent.Tick event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack bow = event.getItem();
        if (entity == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(bow.func_77973_b() instanceof ItemBow)) {
            return;
        }
        if (entity.field_70173_aa % 10 == 0) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)bow);
        if (enchantmentLevel > 0) {
            AxisAlignedBB axis = new AxisAlignedBB(entity.func_180425_c()).func_186662_g((double)(4 + enchantmentLevel * 2));
            EnchantmentPushing.repelEntitiesInAABBFromPoint(entity.field_70170_p, axis, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, enchantmentLevel);
        }
    }

    private static void repelEntitiesInAABBFromPoint(World world, AxisAlignedBB effectBounds, double x, double y, double z, int enchantmentLevel) {
        List list = world.func_72872_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if (!(ent instanceof EntityLiving) && !(ent instanceof IProjectile) || ent.field_70128_L || ent instanceof EntityArrow && ent.field_70122_E) continue;
            Vec3d bowVec = new Vec3d(x, y, z);
            Vec3d entVec = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            Vec3d bowToEntVec = new Vec3d(entVec.field_72450_a - bowVec.field_72450_a, entVec.field_72448_b - bowVec.field_72448_b, entVec.field_72449_c - bowVec.field_72449_c);
            double distance = bowToEntVec.func_72433_c() + 0.1;
            double diminishOverDistance = 10.0 / distance / (double)Math.max(50 - enchantmentLevel * 10, 1);
            ent.field_70159_w += bowToEntVec.field_72450_a / Math.max(5.25 - (double)enchantmentLevel * 1.5, 1.0) * diminishOverDistance;
            ent.field_70181_x += bowToEntVec.field_72448_b / Math.max(6.25 - (double)enchantmentLevel * 1.25, 1.0) * diminishOverDistance;
            ent.field_70179_y += bowToEntVec.field_72449_c / Math.max(5.25 - (double)enchantmentLevel * 1.5, 1.0) * diminishOverDistance;
        }
    }
}

