/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.base;

import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.util.Types;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public abstract class EnchantmentBase
extends Enchantment {
    public Set<Enchantment> incompatibleEnchantments = new HashSet<Enchantment>();

    public EnchantmentBase(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(rarity, Types.NONE, slots);
        this.field_77350_z = name;
        this.setRegistryName("somanyenchantments", name);
    }

    public abstract boolean isEnabled();

    public boolean hasSubscriber() {
        return false;
    }

    public abstract int func_77325_b();

    public int func_77321_a(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77317_b(enchantmentLevel);
    }

    public String func_77316_c(int level) {
        String s = I18n.func_74838_a((String)this.func_77320_a());
        s = !this.isEnabled() ? TextFormatting.DARK_RED + "" + TextFormatting.STRIKETHROUGH + s : this.getPrefix() + s;
        return level == 1 && this.func_77325_b() == 1 ? s : s + " " + I18n.func_74838_a((String)("enchantment.level." + level));
    }

    public abstract boolean func_185261_e();

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean func_77326_a(Enchantment ench) {
        return !this.incompatibleEnchantments.contains(ench) && super.func_77326_a(ench);
    }

    public String getPrefix() {
        return "";
    }

    public void onEntityDamagedAlt(EntityLivingBase user, Entity target, ItemStack weapon, int level) {
    }

    public static boolean isDamageSourceAllowed(DamageSource source) {
        if (source == null) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityLivingBase)) {
            return false;
        }
        if (!ModConfig.miscellaneous.enablePetAttacks && source.func_76346_g() instanceof EntityPlayer && !(source.func_76364_f() instanceof EntityPlayer) && source.func_76364_f() instanceof EntityLivingBase) {
            return false;
        }
        return "player".equals(source.field_76373_n) || "mob".equals(source.field_76373_n);
    }
}

